/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.Params;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnDeleteQuery;
import jakarta.nosql.column.ColumnDeleteQueryParams;
import jakarta.nosql.column.ColumnObserverParser;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.column.ColumnQueryParams;
import jakarta.nosql.column.DeleteQueryConverter;
import jakarta.nosql.column.SelectQueryConverter;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.column.ColumnQueryPagination;
import jakarta.nosql.mapping.column.ColumnTemplate;
import jakarta.nosql.query.DeleteQuery;
import jakarta.nosql.query.SelectQuery;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.query.method.DeleteMethodProvider;
import org.eclipse.jnosql.communication.query.method.SelectMethodProvider;
import org.eclipse.jnosql.mapping.column.query.MappingColumnQuery;
import org.eclipse.jnosql.mapping.column.query.RepositoryColumnObserverParser;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.util.ParamsBinder;

public abstract class BaseColumnRepository<T> {
    private ColumnObserverParser parser;
    private ParamsBinder paramsBinder;
    private static final SelectQueryConverter SELECT_CONVERTER = (SelectQueryConverter)ServiceLoaderProvider.get(SelectQueryConverter.class, () -> ServiceLoader.load(SelectQueryConverter.class));
    private static final DeleteQueryConverter DELETE_CONVERTER = (DeleteQueryConverter)ServiceLoaderProvider.get(DeleteQueryConverter.class, () -> ServiceLoader.load(DeleteQueryConverter.class));

    protected abstract Converters getConverters();

    protected abstract EntityMetadata getEntityMetadata();

    protected abstract ColumnTemplate getTemplate();

    protected ColumnQuery getQuery(Method method, Object[] args) {
        SelectMethodProvider selectMethodFactory = SelectMethodProvider.get();
        SelectQuery selectQuery = (SelectQuery)selectMethodFactory.apply((Object)method, (Object)this.getEntityMetadata().getName());
        ColumnQueryParams queryParams = (ColumnQueryParams)SELECT_CONVERTER.apply((Object)selectQuery, (Object)this.getParser());
        ColumnQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        this.getParamsBinder().bind(params, args, method);
        return this.getQuerySorts(args, query);
    }

    protected ColumnDeleteQuery getDeleteQuery(Method method, Object[] args) {
        DeleteMethodProvider deleteMethodFactory = DeleteMethodProvider.get();
        DeleteQuery deleteQuery = (DeleteQuery)deleteMethodFactory.apply((Object)method, (Object)this.getEntityMetadata().getName());
        ColumnDeleteQueryParams queryParams = (ColumnDeleteQueryParams)DELETE_CONVERTER.apply((Object)deleteQuery, (Object)this.getParser());
        ColumnDeleteQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        this.getParamsBinder().bind(params, args, method);
        return query;
    }

    protected ColumnQuery getQuerySorts(Object[] args, ColumnQuery query) {
        List sorts = DynamicReturn.findSorts((Object[])args);
        if (!sorts.isEmpty()) {
            ArrayList<Sort> newOrders = new ArrayList<Sort>();
            newOrders.addAll(query.getSorts());
            newOrders.addAll(sorts);
            return new MappingColumnQuery(newOrders, query.getLimit(), query.getSkip(), query.getCondition().orElse(null), query.getColumnFamily());
        }
        return query;
    }

    protected ColumnObserverParser getParser() {
        if (this.parser == null) {
            this.parser = new RepositoryColumnObserverParser(this.getEntityMetadata());
        }
        return this.parser;
    }

    protected ParamsBinder getParamsBinder() {
        if (Objects.isNull(this.paramsBinder)) {
            this.paramsBinder = new ParamsBinder(this.getEntityMetadata(), this.getConverters());
        }
        return this.paramsBinder;
    }

    protected Object executeQuery(Method method, Object[] args, Class<?> typeClass, ColumnQuery query) {
        DynamicReturn dynamicReturn = DynamicReturn.builder().withClassSource(typeClass).withMethodSource(method).withResult(() -> this.getTemplate().select(query)).withSingleResult(() -> this.getTemplate().singleResult(query)).withPagination(DynamicReturn.findPagination((Object[])args)).withStreamPagination(this.streamPagination(query)).withSingleResultPagination(this.getSingleResult(query)).withPage(this.getPage(query)).build();
        return dynamicReturn.execute();
    }

    protected Function<Pagination, Page<T>> getPage(ColumnQuery query) {
        return p -> this.getTemplate().select(ColumnQueryPagination.of((ColumnQuery)query, (Pagination)p));
    }

    protected Function<Pagination, Optional<T>> getSingleResult(ColumnQuery query) {
        return p -> {
            ColumnQueryPagination queryPagination = ColumnQueryPagination.of((ColumnQuery)query, (Pagination)p);
            return this.getTemplate().singleResult((ColumnQuery)queryPagination);
        };
    }

    protected Function<Pagination, Stream<T>> streamPagination(ColumnQuery query) {
        return p -> {
            ColumnQueryPagination queryPagination = ColumnQueryPagination.of((ColumnQuery)query, (Pagination)p);
            return this.getTemplate().select((ColumnQuery)queryPagination);
        };
    }
}

