/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.column.ColumnTemplate;
import java.lang.reflect.ParameterizedType;
import org.eclipse.jnosql.mapping.column.query.AbstractColumnRepository;
import org.eclipse.jnosql.mapping.column.query.AbstractColumnRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

class ColumnRepositoryProxy<T, K>
extends AbstractColumnRepositoryProxy {
    private final ColumnTemplate template;
    private final ColumnRepository repository;
    private final EntityMetadata entityMetadata;
    private final Converters converters;

    ColumnRepositoryProxy(ColumnTemplate template, EntitiesMetadata entities, Class<?> repositoryType, Converters converters) {
        this.template = template;
        Class typeClass = (Class)((ParameterizedType)repositoryType.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.entityMetadata = entities.get(typeClass);
        this.repository = new ColumnRepository(template, this.entityMetadata);
        this.converters = converters;
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    @Override
    protected ColumnTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    static class ColumnRepository
    extends AbstractColumnRepository
    implements Repository {
        private final ColumnTemplate template;
        private final EntityMetadata entityMetadata;

        ColumnRepository(ColumnTemplate template, EntityMetadata entityMetadata) {
            this.template = template;
            this.entityMetadata = entityMetadata;
        }

        @Override
        protected ColumnTemplate getTemplate() {
            return this.template;
        }

        @Override
        protected EntityMetadata getEntityMetadata() {
            return this.entityMetadata;
        }
    }
}

