/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.column.ColumnQuery;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.column.ColumnQueryMapper;
import jakarta.nosql.mapping.column.ColumnQueryPagination;
import jakarta.nosql.mapping.column.ColumnTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.mapping.column.query.AbstractMapperQuery;
import org.eclipse.jnosql.mapping.column.query.MappingColumnQuery;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

class DefaultColumnMapperSelectBuilder
extends AbstractMapperQuery
implements ColumnQueryMapper.ColumnMapperFrom,
ColumnQueryMapper.ColumnMapperLimit,
ColumnQueryMapper.ColumnMapperSkip,
ColumnQueryMapper.ColumnMapperOrder,
ColumnQueryMapper.ColumnMapperNameCondition,
ColumnQueryMapper.ColumnMapperNotCondition,
ColumnQueryMapper.ColumnMapperNameOrder,
ColumnQueryMapper.ColumnMapperWhere {
    private final List<Sort> sorts = new ArrayList<Sort>();

    DefaultColumnMapperSelectBuilder(EntityMetadata mapping, Converters converters) {
        super(mapping, converters);
    }

    public ColumnQueryMapper.ColumnMapperNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public ColumnQueryMapper.ColumnMapperNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public ColumnQueryMapper.ColumnMapperNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public ColumnQueryMapper.ColumnMapperSkip skip(long skip) {
        this.start = skip;
        return this;
    }

    public ColumnQueryMapper.ColumnMapperLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    public ColumnQueryMapper.ColumnMapperOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public ColumnQueryMapper.ColumnMapperNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> ColumnQueryMapper.ColumnMapperWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public ColumnQueryMapper.ColumnMapperWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> ColumnQueryMapper.ColumnMapperWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> ColumnQueryMapper.ColumnMapperWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> ColumnQueryMapper.ColumnMapperWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> ColumnQueryMapper.ColumnMapperWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> ColumnQueryMapper.ColumnMapperWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> ColumnQueryMapper.ColumnMapperWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public ColumnQueryMapper.ColumnMapperNameOrder asc() {
        this.sorts.add(Sort.of((String)this.mapping.getColumnField(this.name), (SortType)SortType.ASC));
        return this;
    }

    public ColumnQueryMapper.ColumnMapperNameOrder desc() {
        this.sorts.add(Sort.of((String)this.mapping.getColumnField(this.name), (SortType)SortType.DESC));
        return this;
    }

    public ColumnQuery build() {
        return new MappingColumnQuery(this.sorts, this.limit, this.start, this.condition, this.columnFamily);
    }

    public ColumnQuery build(Pagination pagination) {
        Objects.requireNonNull(pagination, "pagination is required");
        return ColumnQueryPagination.of((ColumnQuery)this.build(), (Pagination)pagination);
    }

    public <T> Stream<T> getResult(ColumnTemplate template) {
        Objects.requireNonNull(template, "template is required");
        return template.select(this.build());
    }

    public <T> Optional<T> getSingleResult(ColumnTemplate template) {
        Objects.requireNonNull(template, "template is required");
        return template.singleResult(this.build());
    }

    public <T> Stream<T> getResult(ColumnTemplate template, Pagination pagination) {
        Objects.requireNonNull(template, "template is required");
        Objects.requireNonNull(pagination, "pagination is required");
        return template.select(this.build(pagination));
    }

    public <T> Optional<T> getSingleResult(ColumnTemplate template, Pagination pagination) {
        Objects.requireNonNull(template, "template is required");
        Objects.requireNonNull(pagination, "pagination is required");
        return template.singleResult(this.build(pagination));
    }

    public <T> Page<T> page(ColumnTemplate template, Pagination pagination) {
        Objects.requireNonNull(pagination, "pagination is required");
        Objects.requireNonNull(template, "template is required");
        return template.select(ColumnQueryPagination.of((ColumnQuery)this.build(), (Pagination)pagination));
    }
}

