/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.column.ColumnQueryMapper;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.column.query.DefaultColumnMapperDeleteBuilder;
import org.eclipse.jnosql.mapping.column.query.DefaultColumnMapperSelectBuilder;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

@ApplicationScoped
class DefaultColumnQueryMapperBuilder
implements ColumnQueryMapper {
    @Inject
    private Instance<EntitiesMetadata> mappings;
    @Inject
    private Instance<Converters> converters;

    DefaultColumnQueryMapperBuilder() {
    }

    public <T> ColumnQueryMapper.ColumnMapperFrom selectFrom(Class<T> type) {
        Objects.requireNonNull(type, "entity is required");
        EntityMetadata mapping = ((EntitiesMetadata)this.mappings.get()).get(type);
        return new DefaultColumnMapperSelectBuilder(mapping, (Converters)this.converters.get());
    }

    public <T> ColumnQueryMapper.ColumnMapperDeleteFrom deleteFrom(Class<T> type) {
        Objects.requireNonNull(type, "entity is required");
        EntityMetadata mapping = ((EntitiesMetadata)this.mappings.get()).get(type);
        return new DefaultColumnMapperDeleteBuilder(mapping, (Converters)this.converters.get());
    }
}

