/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.column.ColumnRepositoryProducer;
import jakarta.nosql.mapping.column.ColumnTemplate;
import jakarta.nosql.mapping.column.ColumnTemplateProducer;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.column.query.ColumnRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@ApplicationScoped
class DefaultColumnRepositoryProducer
implements ColumnRepositoryProducer {
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;
    @Inject
    private ColumnTemplateProducer producer;

    DefaultColumnRepositoryProducer() {
    }

    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, ColumnManager manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        ColumnTemplate template = this.producer.get(manager);
        return this.get(repositoryClass, template);
    }

    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, ColumnTemplate template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        ColumnRepositoryProxy handler = new ColumnRepositoryProxy(template, this.entities, repositoryClass, this.converters);
        return (R)((Repository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

