/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.Sort;
import jakarta.nosql.column.ColumnCondition;
import jakarta.nosql.column.ColumnQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class MappingColumnQuery
implements ColumnQuery {
    private final List<Sort> sorts;
    private final long limit;
    private final long skip;
    private final ColumnCondition condition;
    private final String columnFamily;

    MappingColumnQuery(List<Sort> sorts, long limit, long skip, ColumnCondition condition, String columnFamily) {
        this.sorts = sorts;
        this.limit = limit;
        this.skip = skip;
        this.condition = condition;
        this.columnFamily = columnFamily;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getSkip() {
        return this.skip;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public Optional<ColumnCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public List<String> getColumns() {
        return Collections.emptyList();
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnQuery)) {
            return false;
        }
        ColumnQuery that = (ColumnQuery)o;
        return this.limit == that.getLimit() && this.skip == that.getSkip() && Objects.equals(this.sorts, that.getSorts()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.columnFamily, that.getColumnFamily());
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.skip, this.columnFamily, Collections.emptyList(), this.sorts, this.condition);
    }

    public String toString() {
        return "ArtemisColumnQuery{limit=" + this.limit + ", skip=" + this.skip + ", columnFamily='" + this.columnFamily + "', columns=" + Collections.emptyList() + ", sorts=" + this.sorts + ", condition=" + this.condition + "}";
    }
}

