/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.column.ColumnTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.column.query.ColumnRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.spi.AbstractBean;
import org.eclipse.jnosql.mapping.util.AnnotationLiteralUtil;

public class RepositoryColumnBean
extends AbstractBean<Repository> {
    private final Class type;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public RepositoryColumnBean(Class type, String provider) {
        this.type = type;
        this.types = Collections.singleton(type);
        this.provider = provider;
        if (provider.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)DatabaseQualifier.ofColumn());
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.ANY_ANNOTATION);
        } else {
            this.qualifiers = Collections.singleton(DatabaseQualifier.ofColumn((String)provider));
        }
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Repository create(CreationalContext<Repository> creationalContext) {
        EntitiesMetadata entities = (EntitiesMetadata)this.getInstance(EntitiesMetadata.class);
        ColumnTemplate template = this.provider.isEmpty() ? (ColumnTemplate)this.getInstance(ColumnTemplate.class) : (ColumnTemplate)this.getInstance(ColumnTemplate.class, (Annotation)DatabaseQualifier.ofColumn((String)this.provider));
        Converters converters = (Converters)this.getInstance(Converters.class);
        ColumnRepositoryProxy handler = new ColumnRepositoryProxy(template, entities, this.type, converters);
        return (Repository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@" + DatabaseType.COLUMN + "-" + this.provider;
    }
}

