/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.column.spi;

import jakarta.nosql.column.ColumnManager;
import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.column.ColumnTemplate;
import jakarta.nosql.mapping.column.ColumnTemplateProducer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.spi.AbstractBean;

class TemplateBean
extends AbstractBean<ColumnTemplate> {
    private final Set<Type> types = Collections.singleton(ColumnTemplate.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofColumn((String)provider));
    }

    public Class<?> getBeanClass() {
        return ColumnTemplate.class;
    }

    public ColumnTemplate create(CreationalContext<ColumnTemplate> context) {
        ColumnTemplateProducer producer = (ColumnTemplateProducer)this.getInstance(ColumnTemplateProducer.class);
        ColumnManager manager = this.getColumnManager();
        return producer.get(manager);
    }

    private ColumnManager getColumnManager() {
        return (ColumnManager)this.getInstance(ColumnManager.class, (Annotation)DatabaseQualifier.ofColumn((String)this.provider));
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return ColumnTemplate.class.getName() + DatabaseType.COLUMN + "-" + this.provider;
    }
}

