/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.mapping.EntityPostPersist;
import jakarta.nosql.mapping.EntityPrePersist;
import jakarta.nosql.mapping.document.DocumentDeleteQueryExecute;
import jakarta.nosql.mapping.document.DocumentEntityPostPersist;
import jakarta.nosql.mapping.document.DocumentEntityPrePersist;
import jakarta.nosql.mapping.document.DocumentEventPersistManager;
import jakarta.nosql.mapping.document.DocumentQueryExecute;
import jakarta.nosql.mapping.document.EntityDocumentPostPersist;
import jakarta.nosql.mapping.document.EntityDocumentPrePersist;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.DefaultEntityPostPersist;
import org.eclipse.jnosql.mapping.DefaultEntityPrePersist;
import org.eclipse.jnosql.mapping.document.DefaultDocumentDeleteQueryExecute;
import org.eclipse.jnosql.mapping.document.DefaultDocumentEntityPostPersist;
import org.eclipse.jnosql.mapping.document.DefaultDocumentEntityPrePersist;
import org.eclipse.jnosql.mapping.document.DefaultDocumentQueryExecute;
import org.eclipse.jnosql.mapping.document.DefaultEntityDocumentPostPersist;
import org.eclipse.jnosql.mapping.document.DefaultEntityDocumentPrePersist;

@ApplicationScoped
class DefaultDocumentEventPersistManager
implements DocumentEventPersistManager {
    @Inject
    private Event<DocumentEntityPrePersist> documentEntityPrePersistEvent;
    @Inject
    private Event<DocumentEntityPostPersist> documentEntityPostPersistEvent;
    @Inject
    private Event<EntityPrePersist> entityPrePersistEvent;
    @Inject
    private Event<EntityPostPersist> entityPostPersistEvent;
    @Inject
    private Event<EntityDocumentPrePersist> entityDocumentPrePersist;
    @Inject
    private Event<EntityDocumentPostPersist> entityDocumentPostPersist;
    @Inject
    private Event<DocumentQueryExecute> documentQueryExecute;
    @Inject
    private Event<DocumentDeleteQueryExecute> documentDeleteQueryExecute;

    DefaultDocumentEventPersistManager() {
    }

    public void firePreDocument(DocumentEntity entity) {
        this.documentEntityPrePersistEvent.fire((Object)new DefaultDocumentEntityPrePersist(entity));
    }

    public void firePostDocument(DocumentEntity entity) {
        this.documentEntityPostPersistEvent.fire((Object)new DefaultDocumentEntityPostPersist(entity));
    }

    public <T> void firePreEntity(T entity) {
        this.entityPrePersistEvent.fire((Object)new DefaultEntityPrePersist(entity));
    }

    public <T> void firePostEntity(T entity) {
        this.entityPostPersistEvent.fire((Object)new DefaultEntityPostPersist(entity));
    }

    public <T> void firePreDocumentEntity(T entity) {
        this.entityDocumentPrePersist.fire((Object)new DefaultEntityDocumentPrePersist(entity));
    }

    public <T> void firePostDocumentEntity(T entity) {
        this.entityDocumentPostPersist.fire((Object)new DefaultEntityDocumentPostPersist(entity));
    }

    public void firePreQuery(DocumentQuery query) {
        this.documentQueryExecute.fire((Object)new DefaultDocumentQueryExecute(query));
    }

    public void firePreDeleteQuery(DocumentDeleteQuery query) {
        this.documentDeleteQueryExecute.fire((Object)new DefaultDocumentDeleteQueryExecute(query));
    }
}

