/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.document.Document;
import jakarta.nosql.mapping.AttributeConverter;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.document.DocumentEntityConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jnosql.mapping.document.DocumentFieldValue;
import org.eclipse.jnosql.mapping.reflection.DefaultFieldValue;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.FieldValue;
import org.eclipse.jnosql.mapping.reflection.GenericFieldMapping;
import org.eclipse.jnosql.mapping.reflection.MappingType;

final class DefaultDocumentFieldValue
implements DocumentFieldValue {
    private final FieldValue fieldValue;

    private DefaultDocumentFieldValue(FieldValue fieldValue) {
        this.fieldValue = fieldValue;
    }

    public Object getValue() {
        return this.fieldValue.getValue();
    }

    public FieldMapping getField() {
        return this.fieldValue.getField();
    }

    @Override
    public <X, Y> List<Document> toDocument(DocumentEntityConverter converter, Converters converters) {
        if (MappingType.EMBEDDED.equals((Object)this.getType())) {
            return converter.toDocument(this.getValue()).getDocuments();
        }
        if (MappingType.ENTITY.equals((Object)this.getType())) {
            return Collections.singletonList(Document.of((String)this.getName(), (Object)converter.toDocument(this.getValue()).getDocuments()));
        }
        if (this.isEmbeddableCollection()) {
            return Collections.singletonList(Document.of((String)this.getName(), this.getDocuments(converter)));
        }
        Optional optionalConverter = this.getField().getConverter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((Class)optionalConverter.get());
            return Collections.singletonList(Document.of((String)this.getName(), (Object)attributeConverter.convertToDatabaseColumn(this.getValue())));
        }
        return Collections.singletonList(Document.of((String)this.getName(), (Object)this.getValue()));
    }

    private List<List<Document>> getDocuments(DocumentEntityConverter converter) {
        ArrayList<List<Document>> documents = new ArrayList<List<Document>>();
        for (Object element : (Iterable)this.getValue()) {
            documents.add(converter.toDocument(element).getDocuments());
        }
        return documents;
    }

    private boolean isEmbeddableCollection() {
        return MappingType.COLLECTION.equals((Object)this.getType()) && this.isEmbeddableElement();
    }

    public boolean isNotEmpty() {
        return this.fieldValue.isNotEmpty();
    }

    private MappingType getType() {
        return this.getField().getType();
    }

    private boolean isEmbeddableElement() {
        return ((GenericFieldMapping)this.getField()).isEmbeddable();
    }

    private String getName() {
        return this.getField().getName();
    }

    static DocumentFieldValue of(Object value, FieldMapping field) {
        return new DefaultDocumentFieldValue((FieldValue)new DefaultFieldValue(value, field));
    }

    public String toString() {
        return "DocumentFieldValue{fieldValue=" + this.fieldValue + "}";
    }
}

