/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.Sort;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.document.DocumentQueryPagination;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DefaultDocumentQueryPagination
implements DocumentQueryPagination {
    private final DocumentQuery query;
    private final Pagination pagination;

    DefaultDocumentQueryPagination(DocumentQuery query, Pagination pagination) {
        this.query = query;
        this.pagination = pagination;
    }

    public long getLimit() {
        return this.pagination.getLimit();
    }

    public long getSkip() {
        return this.pagination.getSkip();
    }

    public String getDocumentCollection() {
        return this.query.getDocumentCollection();
    }

    public Optional<DocumentCondition> getCondition() {
        return this.query.getCondition();
    }

    public List<String> getDocuments() {
        return this.query.getDocuments();
    }

    public List<Sort> getSorts() {
        return this.query.getSorts();
    }

    public DocumentQueryPagination next() {
        return new DefaultDocumentQueryPagination(this.query, this.pagination.next());
    }

    public Pagination getPagination() {
        return this.pagination.unmodifiable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDocumentQueryPagination that = (DefaultDocumentQueryPagination)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.pagination, that.pagination);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.pagination);
    }

    public String toString() {
        return "DefaultDocumentQueryPagination{query=" + this.query + ", pagination=" + this.pagination + "}";
    }
}

