/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.document.DocumentEntityConverter;
import jakarta.nosql.mapping.document.DocumentEventPersistManager;
import jakarta.nosql.mapping.document.DocumentTemplate;
import jakarta.nosql.mapping.document.DocumentTemplateProducer;
import jakarta.nosql.mapping.document.DocumentWorkflow;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.document.AbstractDocumentTemplate;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@ApplicationScoped
class DefaultDocumentTemplateProducer
implements DocumentTemplateProducer {
    @Inject
    private DocumentEntityConverter converter;
    @Inject
    private DocumentWorkflow workflow;
    @Inject
    private DocumentEventPersistManager persistManager;
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;

    DefaultDocumentTemplateProducer() {
    }

    public DocumentTemplate get(DocumentManager collectionManager) {
        Objects.requireNonNull(collectionManager, "collectionManager is required");
        return new ProducerDocumentTemplate(this.converter, collectionManager, this.workflow, this.persistManager, this.entities, this.converters);
    }

    @Vetoed
    static class ProducerDocumentTemplate
    extends AbstractDocumentTemplate {
        private DocumentEntityConverter converter;
        private DocumentManager manager;
        private DocumentWorkflow workflow;
        private DocumentEventPersistManager persistManager;
        private Converters converters;
        private EntitiesMetadata entities;

        ProducerDocumentTemplate(DocumentEntityConverter converter, DocumentManager manager, DocumentWorkflow workflow, DocumentEventPersistManager persistManager, EntitiesMetadata entities, Converters converters) {
            this.converter = converter;
            this.manager = manager;
            this.workflow = workflow;
            this.persistManager = persistManager;
            this.entities = entities;
            this.converters = converters;
        }

        ProducerDocumentTemplate() {
        }

        @Override
        protected DocumentEntityConverter getConverter() {
            return this.converter;
        }

        @Override
        protected DocumentManager getManager() {
            return this.manager;
        }

        @Override
        protected DocumentWorkflow getWorkflow() {
            return this.workflow;
        }

        @Override
        protected DocumentEventPersistManager getEventManager() {
            return this.persistManager;
        }

        @Override
        protected EntitiesMetadata getEntities() {
            return this.entities;
        }

        @Override
        protected Converters getConverters() {
            return this.converters;
        }
    }
}

