/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.TypeReference;
import jakarta.nosql.TypeSupplier;
import jakarta.nosql.Value;
import jakarta.nosql.document.Document;
import jakarta.nosql.mapping.AttributeConverter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.mapping.document.AbstractDocumentEntityConverter;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.GenericFieldMapping;
import org.eclipse.jnosql.mapping.reflection.MappingType;

enum FieldConverter {
    EMBEDDED{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            Field nativeField = field.getNativeField();
            Object subEntity = converter.toEntity(nativeField.getType(), documents);
            EntityMetadata mapping = converter.getEntities().get(subEntity.getClass());
            boolean areAllFieldsNull = mapping.getFields().stream().map(f -> f.read(subEntity)).allMatch(Objects::isNull);
            if (!areAllFieldsNull) {
                field.write(instance, subEntity);
            }
        }
    }
    ,
    ENTITY{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                this.converterSubDocument(instance, document, field, converter);
            } else {
                field.write(instance, converter.toEntity(field.getNativeField().getType(), documents));
            }
        }

        private <T> void converterSubDocument(T instance, Document sudDocument, FieldMapping field, AbstractDocumentEntityConverter converter) {
            Object value = sudDocument.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Document> embeddedDocument = new ArrayList<Document>();
                for (Map.Entry entry : map.entrySet()) {
                    embeddedDocument.add(Document.of((String)entry.getKey().toString(), entry.getValue()));
                }
                field.write(instance, converter.toEntity(field.getNativeField().getType(), embeddedDocument));
            } else {
                field.write(instance, converter.toEntity(field.getNativeField().getType(), (List)sudDocument.get((TypeSupplier)new TypeReference<List<Document>>(){})));
            }
        }
    }
    ,
    COLLECTION{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                GenericFieldMapping genericField = (GenericFieldMapping)field;
                Collection collection = genericField.getCollectionInstance();
                List embeddable = (List)document.get();
                for (List documentList : embeddable) {
                    Object element = converter.toEntity(genericField.getElementType(), documentList);
                    collection.add(element);
                }
                field.write(instance, (Object)collection);
            }
        }
    }
    ,
    DEFAULT{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, AbstractDocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                Value value = document.getValue();
                Optional optionalConverter = field.getConverter();
                if (optionalConverter.isPresent()) {
                    AttributeConverter attributeConverter = converter.getConverters().get((Class)optionalConverter.get());
                    Object attributeConverted = attributeConverter.convertToEntityAttribute(value.get());
                    field.write(instance, field.getValue(Value.of((Object)attributeConverted)));
                } else {
                    field.write(instance, field.getValue(value));
                }
            }
        }
    };


    abstract <X, Y, T> void convert(T var1, List<Document> var2, Document var3, FieldMapping var4, AbstractDocumentEntityConverter var5);

    <X, Y, T> void convert(T instance, Document document, FieldMapping field, AbstractDocumentEntityConverter converter) {
        this.convert(instance, null, document, field, converter);
    }

    static FieldConverter get(FieldMapping field) {
        if (MappingType.EMBEDDED.equals((Object)field.getType())) {
            return EMBEDDED;
        }
        if (MappingType.ENTITY.equals((Object)field.getType())) {
            return ENTITY;
        }
        if (FieldConverter.isCollectionEmbeddable(field)) {
            return COLLECTION;
        }
        return DEFAULT;
    }

    private static boolean isCollectionEmbeddable(FieldMapping field) {
        return MappingType.COLLECTION.equals((Object)field.getType()) && ((GenericFieldMapping)field).isEmbeddable();
    }
}

