/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.TypeReference;
import jakarta.nosql.TypeSupplier;
import jakarta.nosql.document.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jnosql.mapping.document.AbstractDocumentEntityConverter;
import org.eclipse.jnosql.mapping.reflection.ConstructorBuilder;
import org.eclipse.jnosql.mapping.reflection.GenericParameterMetaData;
import org.eclipse.jnosql.mapping.reflection.ParameterMetaData;

enum ParameterConverter {
    DEFAULT{

        @Override
        void convert(AbstractDocumentEntityConverter converter, Document document, ParameterMetaData parameterMetaData, ConstructorBuilder builder) {
            parameterMetaData.getConverter().ifPresentOrElse(c -> {
                Object value = converter.getConverters().get(c).convertToEntityAttribute(document.get());
                builder.add(value);
            }, () -> builder.add(document.get()));
        }
    }
    ,
    ENTITY{

        @Override
        void convert(AbstractDocumentEntityConverter converter, Document document, ParameterMetaData parameterMetaData, ConstructorBuilder builder) {
            Object value = document.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Document> documents = new ArrayList<Document>();
                for (Map.Entry entry : map.entrySet()) {
                    documents.add(Document.of((String)entry.getKey().toString(), entry.getValue()));
                }
                Object entity = converter.toEntity(parameterMetaData.getType(), documents);
                builder.add(entity);
            } else {
                List documents = (List)document.get((TypeSupplier)new TypeReference<List<Document>>(){});
                Object entity = converter.toEntity(parameterMetaData.getType(), documents);
                builder.add(entity);
            }
        }
    }
    ,
    COLLECTION{

        @Override
        void convert(AbstractDocumentEntityConverter converter, Document document, ParameterMetaData parameterMetaData, ConstructorBuilder builder) {
            GenericParameterMetaData genericParameter = (GenericParameterMetaData)parameterMetaData;
            Collection elements = genericParameter.getCollectionInstance();
            List embeddable = (List)document.get();
            for (List columnList : embeddable) {
                Object element = converter.toEntity(genericParameter.getElementType(), columnList);
                elements.add(element);
            }
            builder.add((Object)elements);
        }
    };


    abstract void convert(AbstractDocumentEntityConverter var1, Document var2, ParameterMetaData var3, ConstructorBuilder var4);

    static ParameterConverter of(ParameterMetaData parameter) {
        switch (parameter.getParamType()) {
            case COLLECTION: {
                return COLLECTION;
            }
            case ENTITY: {
                return ENTITY;
            }
        }
        return DEFAULT;
    }
}

