/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.nosql.mapping.IdNotFoundException;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.document.DocumentTemplate;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;

public abstract class AbstractDocumentRepository<T, K>
implements Repository<T, K> {
    protected abstract DocumentTemplate getTemplate();

    protected abstract EntityMetadata getEntityMetadata();

    public <S extends T> S save(S entity) {
        Objects.requireNonNull(entity, "Entity is required");
        Object id = this.getIdField().read(entity);
        if (Objects.nonNull(id) && this.existsById(id)) {
            return (S)this.getTemplate().update(entity);
        }
        return (S)this.getTemplate().insert(entity);
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::save).collect(Collectors.toList());
    }

    public void deleteById(K id) {
        Objects.requireNonNull(id, "is is required");
        this.getTemplate().delete(this.getType(), id);
    }

    public void deleteById(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        ids.forEach(this::deleteById);
    }

    public Optional<T> findById(K id) {
        Objects.requireNonNull(id, "id is required");
        return this.getTemplate().find(this.getType(), id);
    }

    public Iterable<T> findById(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        return StreamSupport.stream(ids.spliterator(), false).flatMap(this.optionalToStream()).collect(Collectors.toList());
    }

    public long count() {
        return this.getTemplate().count(this.getType());
    }

    private FieldMapping getIdField() {
        return (FieldMapping)this.getEntityMetadata().getId().orElseThrow(IdNotFoundException.KEY_NOT_FOUND_EXCEPTION_SUPPLIER);
    }

    private Function optionalToStream() {
        return id -> {
            Optional<T> entity = this.findById(id);
            return entity.isPresent() ? Stream.of(entity.get()) : Stream.empty();
        };
    }

    public boolean existsById(K id) {
        return this.findById(id).isPresent();
    }

    private Class<T> getType() {
        return this.getEntityMetadata().getType();
    }
}

