/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.mapping.Repository;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eclipse.jnosql.mapping.document.query.BaseDocumentRepository;
import org.eclipse.jnosql.mapping.query.RepositoryType;
import org.eclipse.jnosql.mapping.repository.DynamicQueryMethodReturn;

public abstract class AbstractDocumentRepositoryProxy<T>
extends BaseDocumentRepository
implements InvocationHandler {
    protected abstract Repository getRepository();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        Class typeClass = this.getEntityMetadata().getType();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                DocumentQuery query = this.getQuery(method, args);
                return this.executeQuery(method, args, typeClass, query);
            }
            case FIND_ALL: {
                DocumentQuery queryFindAll = DocumentQuery.select().from(this.getEntityMetadata().getName()).build();
                return this.executeQuery(method, args, typeClass, this.getQuerySorts(args, queryFindAll));
            }
            case DELETE_BY: {
                DocumentDeleteQuery documentDeleteQuery = this.getDeleteQuery(method, args);
                this.getTemplate().delete(documentDeleteQuery);
                return null;
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(args).withMethod(method).withTypeClass(typeClass).withPrepareConverter(q -> this.getTemplate().prepare(q)).withQueryConverter(q -> this.getTemplate().query(q)).build();
                return methodReturn.execute();
            }
        }
        return Void.class;
    }
}

