/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.document.DocumentRepositoryProducer;
import jakarta.nosql.mapping.document.DocumentTemplate;
import jakarta.nosql.mapping.document.DocumentTemplateProducer;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.document.query.DocumentRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@ApplicationScoped
class DefaultDocumentRepositoryProducer
implements DocumentRepositoryProducer {
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;
    @Inject
    private DocumentTemplateProducer producer;

    DefaultDocumentRepositoryProducer() {
    }

    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, DocumentManager manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        DocumentTemplate template = this.producer.get(manager);
        return this.get(repositoryClass, template);
    }

    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, DocumentTemplate template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        DocumentRepositoryProxy handler = new DocumentRepositoryProxy(template, this.entities, repositoryClass, this.converters);
        return (R)((Repository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

