/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.spi;

import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.Repository;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import org.eclipse.jnosql.mapping.DatabaseMetadata;
import org.eclipse.jnosql.mapping.Databases;
import org.eclipse.jnosql.mapping.document.query.RepositoryDocumentBean;
import org.eclipse.jnosql.mapping.document.spi.TemplateBean;

public class DocumentExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(DocumentExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();
    private final Collection<Class<?>> crudTypes = new HashSet();

    <T extends Repository> void observes(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (Repository.class.equals((Object)javaClass)) {
            return;
        }
        if (Arrays.asList(javaClass.getInterfaces()).contains(Repository.class) && Modifier.isInterface(javaClass.getModifiers())) {
            this.crudTypes.add(javaClass);
        }
    }

    <T, X extends DocumentManager> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.DOCUMENT, this.databases);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        LOGGER.info(String.format("Processing Document extension: %d databases crud %d found", this.databases.size(), this.crudTypes.size()));
        LOGGER.info("Processing repositories as a Document implementation: " + this.crudTypes);
        this.databases.forEach(type -> {
            TemplateBean bean = new TemplateBean(type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean((Bean)new RepositoryDocumentBean((Class)type, ""));
            }
            this.databases.forEach(database -> {
                RepositoryDocumentBean bean = new RepositoryDocumentBean((Class)type, database.getProvider());
                afterBeanDiscovery.addBean((Bean)bean);
            });
        });
    }
}

