/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.mapping.Converters;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.util.ConverterUtil;

abstract class AbstractMapperQuery {
    protected final String documentCollection;
    protected boolean negate;
    protected DocumentCondition condition;
    protected boolean and;
    protected String name;
    protected final transient EntityMetadata mapping;
    protected final transient Converters converters;
    protected final transient JNoSQLDocumentTemplate template;
    protected long start;
    protected long limit;

    AbstractMapperQuery(EntityMetadata mapping, Converters converters, JNoSQLDocumentTemplate template) {
        this.mapping = mapping;
        this.converters = converters;
        this.documentCollection = mapping.name();
        this.template = template;
    }

    protected void appendCondition(DocumentCondition newCondition) {
        DocumentCondition documentCondition = this.getDocumentCondition(newCondition);
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(documentCondition) : this.condition.or(documentCondition)) : documentCondition;
        this.negate = false;
        this.name = null;
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        DocumentCondition newCondition = DocumentCondition.between((Document)Document.of((String)this.mapping.columnField(this.name), Arrays.asList(this.getValue(valueA), this.getValue(valueB))));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        List convertedValues = StreamSupport.stream(values.spliterator(), false).map(this::getValue).collect(Collectors.toList());
        DocumentCondition newCondition = DocumentCondition.in((Document)Document.of((String)this.mapping.columnField(this.name), convertedValues));
        this.appendCondition(newCondition);
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.eq((Document)Document.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.like((Document)Document.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gte((Document)Document.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.gt((Document)Document.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lt((Document)Document.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        DocumentCondition newCondition = DocumentCondition.lte((Document)Document.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected Object getValue(Object value) {
        return ConverterUtil.getValue((Object)value, (EntityMetadata)this.mapping, (String)this.name, (Converters)this.converters);
    }

    private DocumentCondition getDocumentCondition(DocumentCondition newCondition) {
        if (this.negate) {
            return newCondition.negate();
        }
        return newCondition;
    }
}

