/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.mapping.Converters;
import org.eclipse.jnosql.mapping.Database;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.document.AbstractDocumentTemplate;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.document.DocumentEventPersistManager;
import org.eclipse.jnosql.mapping.document.DocumentWorkflow;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@Default
@Database(value=DatabaseType.DOCUMENT)
@ApplicationScoped
class DefaultDocumentTemplate
extends AbstractDocumentTemplate {
    private final DocumentEntityConverter converter;
    private final Instance<DocumentManager> manager;
    private final DocumentWorkflow workflow;
    private final DocumentEventPersistManager persistManager;
    private final EntitiesMetadata entities;
    private final Converters converters;

    @Inject
    DefaultDocumentTemplate(DocumentEntityConverter converter, Instance<DocumentManager> manager, DocumentWorkflow workflow, DocumentEventPersistManager persistManager, EntitiesMetadata entities, Converters converters) {
        this.converter = converter;
        this.manager = manager;
        this.workflow = workflow;
        this.persistManager = persistManager;
        this.entities = entities;
        this.converters = converters;
    }

    @Override
    protected DocumentEntityConverter getConverter() {
        return this.converter;
    }

    @Override
    protected DocumentManager getManager() {
        return (DocumentManager)this.manager.get();
    }

    @Override
    protected DocumentWorkflow getWorkflow() {
        return this.workflow;
    }

    @Override
    protected DocumentEventPersistManager getEventManager() {
        return this.persistManager;
    }

    @Override
    protected EntitiesMetadata getEntities() {
        return this.entities;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }
}

