/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.document.DocumentEventPersistManager;

public abstract class DocumentWorkflow {
    protected abstract DocumentEventPersistManager getEventManager();

    protected abstract DocumentEntityConverter getConverter();

    public <T> T flow(T entity, UnaryOperator<DocumentEntity> action) {
        Function<T, T> flow = this.getFlow(entity, action);
        return flow.apply(entity);
    }

    private <T> Function<T, T> getFlow(T entity, UnaryOperator<DocumentEntity> action) {
        UnaryOperator validation = t -> Objects.requireNonNull(t, "entity is required");
        UnaryOperator firePreEntity = t -> {
            this.getEventManager().firePreEntity(t);
            return t;
        };
        Function<Object, DocumentEntity> converterDocument = t -> this.getConverter().toDocument(t);
        Function<DocumentEntity, Object> converterEntity = t -> this.getConverter().toEntity(entity, (DocumentEntity)t);
        UnaryOperator firePostEntity = t -> {
            this.getEventManager().firePostEntity(t);
            return t;
        };
        return validation.andThen(firePreEntity).andThen(converterDocument).andThen(action).andThen(converterEntity).andThen(firePostEntity);
    }
}

