/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.data.repository.Sort;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentQuery;

public final class MappingDocumentQuery
implements DocumentQuery {
    private final List<Sort> sorts;
    private final long limit;
    private final long skip;
    private final DocumentCondition condition;
    private final String documentCollection;

    public MappingDocumentQuery(List<Sort> sorts, long limit, long skip, DocumentCondition condition, String documentCollection) {
        this.sorts = sorts;
        this.limit = limit;
        this.skip = skip;
        this.condition = condition;
        this.documentCollection = documentCollection;
    }

    public long limit() {
        return this.limit;
    }

    public long skip() {
        return this.skip;
    }

    public String name() {
        return this.documentCollection;
    }

    public Optional<DocumentCondition> condition() {
        return Optional.ofNullable(this.condition);
    }

    public List<Sort> sorts() {
        return this.sorts;
    }

    public List<String> documents() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentQuery)) {
            return false;
        }
        DocumentQuery that = (DocumentQuery)o;
        return this.limit == that.limit() && this.skip == that.skip() && Objects.equals(this.sorts, that.sorts()) && Objects.equals(this.condition, that.condition().orElse(null)) && Objects.equals(this.documentCollection, that.name());
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.skip, this.documentCollection, this.condition, this.sorts, Collections.emptyList());
    }

    public String toString() {
        return "DocumentQuery{limit=" + this.limit + ", skip=" + this.skip + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", sorts=" + this.sorts + ", documents=" + Collections.emptyList() + "}";
    }
}

