/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.data.exceptions.MappingException;
import jakarta.data.repository.PageableRepository;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;
import org.eclipse.jnosql.communication.document.DocumentQuery;
import org.eclipse.jnosql.mapping.document.query.BaseDocumentRepository;
import org.eclipse.jnosql.mapping.query.RepositoryType;
import org.eclipse.jnosql.mapping.repository.DynamicQueryMethodReturn;

public abstract class AbstractDocumentRepositoryProxy<T>
extends BaseDocumentRepository
implements InvocationHandler {
    protected abstract PageableRepository getRepository();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        Class typeClass = this.getEntityMetadata().type();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                return this.executeFindByQuery(method, args, typeClass, this.getQuery(method, args));
            }
            case COUNT_BY: {
                return this.executeCountByQuery(this.getQuery(method, args));
            }
            case EXISTS_BY: {
                return this.executeExistsByQuery(this.getQuery(method, args));
            }
            case FIND_ALL: {
                DocumentQuery queryFindAll = DocumentQuery.select().from(this.getEntityMetadata().name()).build();
                return this.executeFindByQuery(method, args, typeClass, this.updateQueryDynamically(args, queryFindAll));
            }
            case DELETE_BY: {
                DocumentDeleteQuery documentDeleteQuery = this.getDeleteQuery(method, args);
                this.getTemplate().delete(documentDeleteQuery);
                return null;
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case DEFAULT_METHOD: {
                return InvocationHandler.invokeDefault(instance, method, args);
            }
            case ORDER_BY: {
                throw new MappingException("Eclipse JNoSQL has not support for method that has OrderBy annotation");
            }
            case QUERY: {
                DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(args).withMethod(method).withTypeClass(typeClass).withPrepareConverter(q -> this.getTemplate().prepare((String)q)).withQueryConverter(q -> this.getTemplate().query((String)q)).build();
                return methodReturn.execute();
            }
        }
        return Void.class;
    }
}

