/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.data.exceptions.MappingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jnosql.communication.Entry;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.mapping.Converters;
import org.eclipse.jnosql.mapping.document.DefaultDocumentFieldValue;
import org.eclipse.jnosql.mapping.document.DocumentFieldValue;
import org.eclipse.jnosql.mapping.document.FieldConverter;
import org.eclipse.jnosql.mapping.document.ParameterConverter;
import org.eclipse.jnosql.mapping.metadata.ConstructorBuilder;
import org.eclipse.jnosql.mapping.metadata.ConstructorMetadata;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldValue;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;

public abstract class DocumentEntityConverter {
    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    public DocumentEntity toDocument(Object entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().get(entity.getClass());
        DocumentEntity communication = DocumentEntity.of((String)mapping.name());
        mapping.fields().stream().map(f -> this.to((FieldMetadata)f, entity)).filter(FieldValue::isNotEmpty).map(f -> f.toDocument(this, this.getConverters())).flatMap(Collection::stream).forEach(arg_0 -> ((DocumentEntity)communication).add(arg_0));
        mapping.inheritance().ifPresent(i -> communication.add(i.discriminatorColumn(), (Object)i.discriminatorValue()));
        return communication;
    }

    public <T> T toEntity(Class<T> type, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        return this.toEntity(type, entity.documents());
    }

    public <T> T toEntity(T type, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        if (type.getClass().isRecord()) {
            return (T)this.toEntity(type.getClass(), entity.documents());
        }
        EntityMetadata mapping = this.getEntities().get(type.getClass());
        return this.convertEntity(entity.documents(), mapping, type);
    }

    public <T> T toEntity(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().findByName(entity.name());
        if (mapping.isInheritance()) {
            return this.mapInheritanceEntity(entity, mapping.type());
        }
        ConstructorMetadata constructor = mapping.constructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.documents(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.documents(), mapping);
    }

    protected <T> T toEntity(Class<T> type, List<Document> documents) {
        EntityMetadata mapping = this.getEntities().get(type);
        if (mapping.isInheritance()) {
            return this.inheritanceToEntity(documents, mapping);
        }
        ConstructorMetadata constructor = mapping.constructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(documents, mapping, instance);
        }
        return this.convertEntityByConstructor(documents, mapping);
    }

    protected <T> Consumer<String> feedObject(T entity, List<Document> documents, Map<String, FieldMetadata> fieldsGroupByName) {
        return k -> {
            Optional<Document> document = documents.stream().filter(c -> c.name().equals(k)).findFirst();
            FieldMetadata field = (FieldMetadata)fieldsGroupByName.get(k);
            FieldConverter fieldConverter = FieldConverter.get(field);
            if (MappingType.ENTITY.equals((Object)field.mappingType())) {
                document.ifPresent(d -> fieldConverter.convert(entity, null, (Document)d, field, this));
            } else {
                fieldConverter.convert(entity, documents, document.orElse(null), field, this);
            }
        };
    }

    private <T> T convertEntityByConstructor(List<Document> documents, EntityMetadata mapping) {
        ConstructorBuilder builder = ConstructorBuilder.of((ConstructorMetadata)mapping.constructor());
        for (ParameterMetaData parameter : builder.parameters()) {
            Optional<Document> document = documents.stream().filter(c -> c.name().equals(parameter.name())).findFirst();
            document.ifPresentOrElse(c -> {
                ParameterConverter converter = ParameterConverter.of(parameter);
                converter.convert(this, (Document)c, parameter, builder);
            }, () -> ((ConstructorBuilder)builder).addEmptyParameter());
        }
        return (T)builder.build();
    }

    private <T> T mapInheritanceEntity(DocumentEntity entity, Class<?> type) {
        Map group = this.getEntities().findByParentGroupByDiscriminatorValue(type);
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the document collection " + entity.name());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::discriminatorColumn).orElseThrow();
        String discriminator = (String)entity.find(column, String.class).orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Document Collection, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata mapping = this.getEntities().get(inheritance.entity());
        ConstructorMetadata constructor = mapping.constructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.documents(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.documents(), mapping);
    }

    private <T> T convertEntity(List<Document> documents, EntityMetadata mapping, T instance) {
        Map fieldsGroupByName = mapping.fieldsGroupByName();
        List<String> names = documents.stream().map(Entry::name).sorted().toList();
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        Predicate<String> isElementType = k -> {
            MappingType type = ((FieldMetadata)fieldsGroupByName.get(k)).mappingType();
            return MappingType.EMBEDDED.equals((Object)type) || MappingType.ENTITY.equals((Object)type);
        };
        fieldsGroupByName.keySet().stream().filter(existField.or(isElementType)).forEach(this.feedObject(instance, documents, fieldsGroupByName));
        return instance;
    }

    private <T> T inheritanceToEntity(List<Document> documents, EntityMetadata mapping) {
        Map group = this.getEntities().findByParentGroupByDiscriminatorValue(mapping.type());
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the document collection " + mapping.name());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::discriminatorColumn).orElseThrow();
        String discriminator = documents.stream().filter(d -> d.name().equals(column)).findFirst().map(d -> (String)d.get(String.class)).orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Document Collection, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata inheritanceMetadata = this.getEntities().get(inheritance.entity());
        Object instance = inheritanceMetadata.newInstance();
        return (T)this.convertEntity(documents, inheritanceMetadata, instance);
    }

    private DocumentFieldValue to(FieldMetadata field, Object entityInstance) {
        Object value = field.read(entityInstance);
        return DefaultDocumentFieldValue.of(value, field);
    }
}

