/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.util.Optional;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

final class DocumentMapperObserver
implements DocumentObserverParser {
    private final EntitiesMetadata mappings;

    DocumentMapperObserver(EntitiesMetadata mappings) {
        this.mappings = mappings;
    }

    public String fireEntity(String entity) {
        Optional<EntityMetadata> entityMetadata = this.getEntityMetadata(entity);
        return entityMetadata.map(EntityMetadata::name).orElse(entity);
    }

    public String fireField(String entity, String field) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(c -> c.columnField(field)).orElse(field);
    }

    private Optional<EntityMetadata> getEntityMetadata(String entity) {
        Optional bySimpleName = this.mappings.findBySimpleName(entity);
        if (bySimpleName.isPresent()) {
            return bySimpleName;
        }
        return this.mappings.findByClassName(entity);
    }
}

