/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.nosql.PreparedStatement;
import jakarta.nosql.QueryMapper;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.DocumentQuery;
import org.eclipse.jnosql.communication.document.DocumentQueryParser;
import org.eclipse.jnosql.mapping.Converters;
import org.eclipse.jnosql.mapping.IdNotFoundException;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.document.DocumentEventPersistManager;
import org.eclipse.jnosql.mapping.document.DocumentMapperDelete;
import org.eclipse.jnosql.mapping.document.DocumentMapperObserver;
import org.eclipse.jnosql.mapping.document.DocumentMapperSelect;
import org.eclipse.jnosql.mapping.document.DocumentPreparedStatement;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.util.ConverterUtil;

public abstract class AbstractDocumentTemplate
implements JNoSQLDocumentTemplate {
    private static final DocumentQueryParser PARSER = new DocumentQueryParser();
    private final UnaryOperator<DocumentEntity> insert = e -> this.getManager().insert(e);
    private final UnaryOperator<DocumentEntity> update = e -> this.getManager().update(e);
    private DocumentObserverParser columnQueryParser;

    protected abstract DocumentEntityConverter getConverter();

    protected abstract DocumentManager getManager();

    protected abstract DocumentEventPersistManager getEventManager();

    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    private DocumentObserverParser getObserver() {
        if (Objects.isNull(this.columnQueryParser)) {
            this.columnQueryParser = new DocumentMapperObserver(this.getEntities());
        }
        return this.columnQueryParser;
    }

    public <T> T insert(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.persist(entity, this.insert);
    }

    public <T> T insert(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return this.persist(entity, e -> this.getManager().insert(e, ttl));
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entity is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(e -> this.insert(e, ttl)).collect(Collectors.toList());
    }

    public <T> T update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return this.persist(entity, this.update);
    }

    public <T> Iterable<T> update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entity is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    @Override
    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getManager().delete(query);
    }

    @Override
    public <T> Stream<T> select(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.executeQuery(query);
    }

    @Override
    public boolean exists(DocumentQuery query) {
        return this.getManager().exists(query);
    }

    @Override
    public long count(DocumentQuery query) {
        return this.getManager().count(query);
    }

    @Override
    public <T> Optional<T> singleResult(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> entities = this.select(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        FieldMetadata idField = (FieldMetadata)entityMetadata.id().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.fieldName(), (Converters)this.getConverters());
        DocumentQuery query = DocumentQuery.select().from(entityMetadata.name()).where(idField.name()).eq(value).build();
        return this.singleResult(query);
    }

    public <T, K> void delete(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        FieldMetadata idField = (FieldMetadata)entityMetadata.id().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.fieldName(), (Converters)this.getConverters());
        DocumentDeleteQuery query = DocumentDeleteQuery.delete().from(entityMetadata.name()).where(idField.name()).eq(value).build();
        this.delete(query);
    }

    public <T> Stream<T> query(String query) {
        Objects.requireNonNull(query, "query is required");
        return PARSER.query(query, this.getManager(), this.getObserver()).map(c -> this.getConverter().toEntity((DocumentEntity)c));
    }

    public <T> Optional<T> singleResult(String query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> entities = this.query(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    public PreparedStatement prepare(String query) {
        return new DocumentPreparedStatement(PARSER.prepare(query, this.getManager(), this.getObserver()), this.getConverter());
    }

    public long count(String documentCollection) {
        return this.getManager().count(documentCollection);
    }

    public <T> long count(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        return this.getManager().count(entityMetadata.name());
    }

    private <T> Stream<T> executeQuery(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream entities = this.getManager().select(query);
        Function<DocumentEntity, Object> function = e -> this.getConverter().toEntity((DocumentEntity)e);
        return entities.map(function).peek(this.getEventManager()::firePostEntity);
    }

    public <T> QueryMapper.MapperFrom select(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.getEntities().get(type);
        return new DocumentMapperSelect(metadata, this.getConverters(), this);
    }

    public <T> QueryMapper.MapperDeleteFrom delete(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.getEntities().get(type);
        return new DocumentMapperDelete(metadata, this.getConverters(), this);
    }

    @Override
    public <T> Stream<T> findAll(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.getEntities().get(type);
        DocumentQuery query = DocumentQuery.select().from(metadata.name()).build();
        return this.select(query);
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.getEntities().get(type);
        DocumentDeleteQuery query = DocumentDeleteQuery.delete().from(metadata.name()).build();
        this.delete(query);
    }

    protected <T> T persist(T entity, UnaryOperator<DocumentEntity> persistAction) {
        return (T)Stream.of(entity).map(this.toUnary(this.getEventManager()::firePreEntity)).map(this.getConverter()::toDocument).map(persistAction).map(t -> this.getConverter().toEntity(entity, (DocumentEntity)t)).map(this.toUnary(this.getEventManager()::firePostEntity)).findFirst().orElseThrow();
    }

    private <T> UnaryOperator<T> toUnary(Consumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return t;
        };
    }
}

