/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.QueryMapper;
import java.util.Objects;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.document.AbstractMapperQuery;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.document.MappingDocumentDeleteQuery;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

final class DocumentMapperDelete
extends AbstractMapperQuery
implements QueryMapper.MapperDeleteFrom,
QueryMapper.MapperDeleteWhere,
QueryMapper.MapperDeleteNameCondition,
QueryMapper.MapperDeleteNotCondition {
    DocumentMapperDelete(EntityMetadata mapping, Converters converters, JNoSQLDocumentTemplate template) {
        super(mapping, converters, template);
    }

    public QueryMapper.MapperDeleteNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperDeleteNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public QueryMapper.MapperDeleteNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public QueryMapper.MapperDeleteNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public QueryMapper.MapperDeleteWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    private DocumentDeleteQuery build() {
        return new MappingDocumentDeleteQuery(this.documentCollection, this.condition);
    }

    public void execute() {
        DocumentDeleteQuery query = this.build();
        this.template.delete(query);
    }
}

