/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.data.repository.Direction;
import jakarta.data.repository.Sort;
import jakarta.nosql.QueryMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.document.DocumentQuery;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.document.AbstractMapperQuery;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.document.MappingDocumentQuery;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

final class DocumentMapperSelect
extends AbstractMapperQuery
implements QueryMapper.MapperFrom,
QueryMapper.MapperLimit,
QueryMapper.MapperSkip,
QueryMapper.MapperOrder,
QueryMapper.MapperNameCondition,
QueryMapper.MapperNotCondition,
QueryMapper.MapperNameOrder,
QueryMapper.MapperWhere {
    private final List<Sort> sorts = new ArrayList<Sort>();

    DocumentMapperSelect(EntityMetadata mapping, Converters converters, JNoSQLDocumentTemplate template) {
        super(mapping, converters, template);
    }

    public QueryMapper.MapperNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public QueryMapper.MapperNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public QueryMapper.MapperNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperSkip skip(long start) {
        this.start = start;
        return this;
    }

    public QueryMapper.MapperLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    public QueryMapper.MapperOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> QueryMapper.MapperWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public QueryMapper.MapperWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> QueryMapper.MapperWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public QueryMapper.MapperNameOrder asc() {
        this.sorts.add(Sort.of((String)this.mapping.columnField(this.name), (Direction)Direction.ASC, (boolean)false));
        return this;
    }

    public QueryMapper.MapperNameOrder desc() {
        this.sorts.add(Sort.of((String)this.mapping.columnField(this.name), (Direction)Direction.DESC, (boolean)false));
        return this;
    }

    private DocumentQuery build() {
        return new MappingDocumentQuery(this.sorts, this.limit, this.start, this.condition, this.documentCollection);
    }

    public <T> List<T> result() {
        DocumentQuery query = this.build();
        return this.template.select(query).toList();
    }

    public <T> Stream<T> stream() {
        DocumentQuery query = this.build();
        return this.template.select(query);
    }

    public <T> Optional<T> singleResult() {
        DocumentQuery query = this.build();
        return this.template.singleResult(query);
    }
}

