/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.data.repository.PageableRepository;
import java.lang.reflect.ParameterizedType;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.document.query.AbstractDocumentRepository;
import org.eclipse.jnosql.mapping.document.query.AbstractDocumentRepositoryProxy;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

class DocumentRepositoryProxy<T>
extends AbstractDocumentRepositoryProxy<T> {
    private final JNoSQLDocumentTemplate template;
    private final DocumentRepository repository;
    private final EntityMetadata entityMetadata;
    private final Converters converters;
    private final Class<?> repositoryType;

    DocumentRepositoryProxy(JNoSQLDocumentTemplate template, EntitiesMetadata entities, Class<?> repositoryType, Converters converters) {
        this.template = template;
        Class typeClass = (Class)((ParameterizedType)repositoryType.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.entityMetadata = entities.get(typeClass);
        this.repository = new DocumentRepository(template, this.entityMetadata);
        this.converters = converters;
        this.repositoryType = repositoryType;
    }

    @Override
    protected PageableRepository getRepository() {
        return this.repository;
    }

    @Override
    protected Class<?> repositoryType() {
        return this.repositoryType;
    }

    @Override
    protected JNoSQLDocumentTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    static class DocumentRepository
    extends AbstractDocumentRepository
    implements PageableRepository {
        private final JNoSQLDocumentTemplate template;
        private final EntityMetadata entityMetadata;

        DocumentRepository(JNoSQLDocumentTemplate template, EntityMetadata entityMetadata) {
            this.template = template;
            this.entityMetadata = entityMetadata;
        }

        @Override
        protected JNoSQLDocumentTemplate getTemplate() {
            return this.template;
        }

        @Override
        protected EntityMetadata getEntityMetadata() {
            return this.entityMetadata;
        }
    }
}

