/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.configuration;

import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.semistructured.DatabaseConfiguration;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DatabaseManagerFactory;
import org.eclipse.jnosql.mapping.Database;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.core.config.MicroProfileSettings;
import org.eclipse.jnosql.mapping.reflection.Reflections;

@ApplicationScoped
class DocumentManagerSupplier
implements Supplier<DatabaseManager> {
    private static final Logger LOGGER = Logger.getLogger(DocumentManagerSupplier.class.getName());

    DocumentManagerSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    @Database(value=DatabaseType.DOCUMENT)
    public DatabaseManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        DatabaseConfiguration configuration = settings.get((Supplier)MappingConfigurations.DOCUMENT_PROVIDER, Class.class).filter(DatabaseConfiguration.class::isAssignableFrom).map(c -> {
            Reflections reflections = (Reflections)CDI.current().select(Reflections.class, new Annotation[0]).get();
            return (DatabaseConfiguration)Reflections.newInstance((Class)c);
        }).orElseGet(DatabaseConfiguration::getConfiguration);
        DatabaseManagerFactory managerFactory = (DatabaseManagerFactory)configuration.apply((Object)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.DOCUMENT_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.DOCUMENT_DATABASE.get()));
        DatabaseManager manager = (DatabaseManager)managerFactory.apply((Object)db);
        LOGGER.log(Level.FINEST, "Starting  a DocumentManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes @Database(value=DatabaseType.DOCUMENT) DatabaseManager manager) {
        LOGGER.log(Level.FINEST, "Closing DocumentManager resource, database name: " + manager.name());
        manager.close();
    }
}

