/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.spi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.mapping.DatabaseMetadata;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.Databases;
import org.eclipse.jnosql.mapping.document.query.CustomRepositoryDocumentBean;
import org.eclipse.jnosql.mapping.document.query.RepositoryDocumentBean;
import org.eclipse.jnosql.mapping.document.spi.TemplateBean;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;

public class DocumentExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(DocumentExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();

    <T, X extends DatabaseManager> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.DOCUMENT, this.databases);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        ClassScanner scanner = ClassScanner.load();
        Set crudTypes = scanner.repositoriesStandard();
        Set customRepositories = scanner.customRepositories();
        LOGGER.info(() -> String.format("Processing Document extension: %d databases crud %d found, custom repositories: %d", this.databases.size(), crudTypes.size(), customRepositories.size()));
        LOGGER.info(() -> "Processing repositories as a Document implementation: " + crudTypes);
        this.databases.forEach(type -> {
            if (!type.getProvider().isBlank()) {
                TemplateBean bean = new TemplateBean(type.getProvider());
                afterBeanDiscovery.addBean((Bean)bean);
            }
        });
        crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean(new RepositoryDocumentBean((Class<?>)type, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean(new RepositoryDocumentBean((Class<?>)type, database.getProvider())));
        });
        customRepositories.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean(new CustomRepositoryDocumentBean((Class<?>)type, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean(new CustomRepositoryDocumentBean((Class<?>)type, database.getProvider())));
        });
    }
}

