/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.eclipse.jnosql.mapping.core.util.AnnotationLiteralUtil;
import org.eclipse.jnosql.mapping.document.DocumentTemplate;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.query.CustomRepositoryHandler;

public class CustomRepositoryDocumentBean<T>
extends AbstractBean<T> {
    private final Class<T> type;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public CustomRepositoryDocumentBean(Class<?> type, String provider) {
        this.type = type;
        this.types = Collections.singleton(type);
        this.provider = provider;
        if (provider.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)DatabaseQualifier.ofDocument());
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.ANY_ANNOTATION);
        } else {
            this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
        }
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public T create(CreationalContext<T> context) {
        EntitiesMetadata entities = (EntitiesMetadata)this.getInstance(EntitiesMetadata.class);
        DocumentTemplate template = this.provider.isEmpty() ? (DocumentTemplate)this.getInstance(DocumentTemplate.class) : (DocumentTemplate)this.getInstance(DocumentTemplate.class, (Annotation)DatabaseQualifier.ofDocument((String)this.provider));
        Converters converters = (Converters)this.getInstance(Converters.class);
        CustomRepositoryHandler handler = CustomRepositoryHandler.builder().entitiesMetadata(entities).template((SemiStructuredTemplate)template).customRepositoryType(this.type).converters(converters).build();
        return (T)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, (InvocationHandler)handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@" + DatabaseType.DOCUMENT + "-" + this.provider;
    }
}

