/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.spi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.nosql.Template;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.eclipse.jnosql.mapping.document.DocumentTemplate;
import org.eclipse.jnosql.mapping.document.DocumentTemplateProducer;

class TemplateBean
extends AbstractBean<DocumentTemplate> {
    private static final Set<Type> TYPES = Set.of(DocumentTemplate.class, Template.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
    }

    public Class<?> getBeanClass() {
        return DocumentTemplate.class;
    }

    public DocumentTemplate create(CreationalContext<DocumentTemplate> context) {
        DocumentTemplateProducer producer = (DocumentTemplateProducer)this.getInstance(DocumentTemplateProducer.class);
        DatabaseManager manager = this.getManager();
        return producer.apply(manager);
    }

    private DatabaseManager getManager() {
        return (DatabaseManager)this.getInstance(DatabaseManager.class, (Annotation)DatabaseQualifier.ofDocument((String)this.provider));
    }

    public Set<Type> getTypes() {
        return TYPES;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return DocumentTemplate.class.getName() + DatabaseType.DOCUMENT + "-" + this.provider;
    }
}

