/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.document.DocumentTemplate;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.AbstractSemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;
import org.eclipse.jnosql.mapping.semistructured.EventPersistManager;

@ApplicationScoped
public class DocumentTemplateProducer
implements Function<DatabaseManager, DocumentTemplate> {
    @Inject
    private EntityConverter converter;
    @Inject
    private EventPersistManager eventManager;
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;

    @Override
    public DocumentTemplate apply(DatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return new ProducerDocumentTemplate(this.converter, manager, this.eventManager, this.entities, this.converters);
    }

    @Vetoed
    static class ProducerDocumentTemplate
    extends AbstractSemiStructuredTemplate
    implements DocumentTemplate {
        private final EntityConverter converter;
        private final DatabaseManager manager;
        private final EventPersistManager eventManager;
        private final EntitiesMetadata entities;
        private final Converters converters;

        ProducerDocumentTemplate(EntityConverter converter, DatabaseManager manager, EventPersistManager eventManager, EntitiesMetadata entities, Converters converters) {
            this.converter = converter;
            this.manager = manager;
            this.eventManager = eventManager;
            this.entities = entities;
            this.converters = converters;
        }

        ProducerDocumentTemplate() {
            this(null, null, null, null, null);
        }

        protected EntityConverter converter() {
            return this.converter;
        }

        protected DatabaseManager manager() {
            return this.manager;
        }

        protected EventPersistManager eventManager() {
            return this.eventManager;
        }

        protected EntitiesMetadata entities() {
            return this.entities;
        }

        protected Converters converters() {
            return this.converters;
        }
    }
}

