/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.Value;
import jakarta.nosql.mapping.AttributeConverter;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.EntityNotFoundException;
import jakarta.nosql.mapping.MappingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.DefaultEdgeEntity;
import org.eclipse.jnosql.mapping.graph.DefaultProperty;
import org.eclipse.jnosql.mapping.graph.EdgeEntity;
import org.eclipse.jnosql.mapping.graph.FieldGraph;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphEventPersistManager;
import org.eclipse.jnosql.mapping.reflection.ConstructorBuilder;
import org.eclipse.jnosql.mapping.reflection.ConstructorMetadata;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.InheritanceMetadata;
import org.eclipse.jnosql.mapping.reflection.MappingType;
import org.eclipse.jnosql.mapping.reflection.ParameterMetaData;

abstract class AbstractGraphConverter
implements GraphConverter {
    AbstractGraphConverter() {
    }

    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    protected abstract GraphEventPersistManager getEventManager();

    protected abstract Graph getGraph();

    @Override
    public <T> Vertex toVertex(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().get(entity.getClass());
        String label = mapping.getName();
        List fields = mapping.getFields().stream().map(f -> this.to((FieldMapping)f, entity)).filter(FieldGraph::isNotEmpty).collect(Collectors.toList());
        Optional<FieldGraph> id = fields.stream().filter(FieldGraph::isId).findFirst();
        Function<Property, Vertex> findVertexOrCreateWithId = p -> {
            Iterator vertices = this.getGraph().vertices(new Object[]{p.value()});
            return vertices.hasNext() ? (Vertex)vertices.next() : this.getGraph().addVertex(new Object[]{T.label, label, T.id, p.value()});
        };
        Vertex vertex = id.map(i -> i.toElement(this.getConverters())).map(findVertexOrCreateWithId).orElseGet(() -> this.getGraph().addVertex(label));
        fields.stream().filter(FieldGraph::isNotId).flatMap(f -> f.toElements(this, this.getConverters()).stream()).forEach(p -> vertex.property(p.key(), p.value()));
        mapping.getInheritance().ifPresent(i -> vertex.property(i.getDiscriminatorColumn(), (Object)i.getDiscriminatorValue()));
        return vertex;
    }

    @Override
    public <T> List<Property<?>> getProperties(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().get(entity.getClass());
        List fields = mapping.getFields().stream().map(f -> this.to((FieldMapping)f, entity)).filter(FieldGraph::isNotEmpty).collect(Collectors.toList());
        return fields.stream().filter(FieldGraph::isNotId).flatMap(f -> f.toElements(this, this.getConverters()).stream()).collect(Collectors.toList());
    }

    @Override
    public <T> T toEntity(Vertex vertex) {
        Objects.requireNonNull(vertex, "vertex is required");
        EntityMetadata mapping = this.getEntities().findByName(vertex.label());
        ConstructorMetadata constructor = mapping.getConstructor();
        if (constructor.isDefault()) {
            List<Property> properties = vertex.keys().stream().map(k -> DefaultProperty.of(k, vertex.value(k))).collect(Collectors.toList());
            T entity = mapping.isInheritance() ? this.mapInheritanceEntity(vertex, properties, mapping.getType()) : this.toEntity(mapping.getType(), properties);
            this.feedId(vertex, entity);
            this.getEventManager().firePostEntity(entity);
            return entity;
        }
        return this.convertEntityByConstructor(vertex, mapping);
    }

    @Override
    public <T> T toEntity(Class<T> type, Vertex vertex) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(vertex, "vertex is required");
        List<Property> properties = vertex.keys().stream().map(k -> DefaultProperty.of(k, vertex.value(k))).collect(Collectors.toList());
        T entity = this.toEntity(type, properties);
        this.feedId(vertex, entity);
        this.getEventManager().firePostEntity(entity);
        return entity;
    }

    @Override
    public <T> T toEntity(T type, Vertex vertex) {
        Objects.requireNonNull(type, "entityInstance is required");
        Objects.requireNonNull(vertex, "vertex is required");
        List<Property> properties = vertex.keys().stream().map(k -> DefaultProperty.of(k, vertex.value(k))).collect(Collectors.toList());
        EntityMetadata mapping = this.getEntities().get(type.getClass());
        this.convertEntity(properties, mapping, type);
        this.feedId(vertex, type);
        return type;
    }

    @Override
    public EdgeEntity toEdgeEntity(Edge edge) {
        Objects.requireNonNull(edge, "vertex is required");
        Object out = this.toEntity(edge.outVertex());
        Object in = this.toEntity(edge.inVertex());
        return new DefaultEdgeEntity(edge, in, out);
    }

    @Override
    public Edge toEdge(EdgeEntity edge) {
        Objects.requireNonNull(edge, "vertex is required");
        Object id = edge.getId();
        Iterator edges = this.getGraph().edges(new Object[]{id});
        if (edges.hasNext()) {
            return (Edge)edges.next();
        }
        throw new EntityNotFoundException("Edge does not found in the database with id: " + id);
    }

    private <T> T convertEntityByConstructor(Vertex vertex, EntityMetadata mapping) {
        ConstructorBuilder builder = ConstructorBuilder.of((ConstructorMetadata)mapping.getConstructor());
        List properties = vertex.keys().stream().map(k -> DefaultProperty.of(k, vertex.value(k))).collect(Collectors.toList());
        for (ParameterMetaData parameter : builder.getParameters()) {
            Optional<Property> property = properties.stream().filter(c -> c.key().equals(parameter.getName())).findFirst();
            property.ifPresentOrElse(p -> parameter.getConverter().ifPresentOrElse(c -> {
                Object value = this.getConverters().get(c).convertToEntityAttribute(p.value());
                builder.add(value);
            }, () -> builder.add(p.value())), () -> ((ConstructorBuilder)builder).addEmptyParameter());
        }
        return (T)builder.build();
    }

    private <T> void feedId(Vertex vertex, T entity) {
        EntityMetadata mapping = this.getEntities().get(entity.getClass());
        Optional id = mapping.getId();
        Object vertexId = vertex.id();
        if (Objects.nonNull(vertexId) && id.isPresent()) {
            FieldMapping fieldMapping = (FieldMapping)id.get();
            if (fieldMapping.getConverter().isPresent()) {
                AttributeConverter attributeConverter = this.getConverters().get((Class)fieldMapping.getConverter().get());
                Object attributeConverted = attributeConverter.convertToEntityAttribute(vertexId);
                fieldMapping.write(entity, fieldMapping.getValue(Value.of((Object)attributeConverted)));
            } else {
                fieldMapping.write(entity, fieldMapping.getValue(Value.of((Object)vertexId)));
            }
        }
    }

    private <T> T toEntity(Class<T> type, List<Property> properties) {
        EntityMetadata mapping = this.getEntities().get(type);
        Object instance = mapping.newInstance();
        return (T)this.convertEntity(properties, mapping, instance);
    }

    private <T> T convertEntity(List<Property> elements, EntityMetadata mapping, T instance) {
        Map fieldsGroupByName = mapping.getFieldsGroupByName();
        List names = elements.stream().map(Property::key).sorted().collect(Collectors.toList());
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        fieldsGroupByName.keySet().stream().filter(existField.or(k -> MappingType.EMBEDDED.equals((Object)((FieldMapping)fieldsGroupByName.get(k)).getType()))).forEach(this.feedObject(instance, elements, fieldsGroupByName));
        return instance;
    }

    private <T> Consumer<String> feedObject(T instance, List<Property> elements, Map<String, FieldMapping> fieldsGroupByName) {
        return k -> {
            Optional<Property> element = elements.stream().filter(c -> c.key().equals(k)).findFirst();
            FieldMapping field = (FieldMapping)fieldsGroupByName.get(k);
            if (MappingType.EMBEDDED.equals((Object)field.getType())) {
                this.embeddedField(instance, elements, field);
            } else {
                element.ifPresent(e -> this.singleField(instance, (Property)e, field));
            }
        };
    }

    private <T, X, Y> void singleField(T instance, Property element, FieldMapping field) {
        Object value = element.value();
        Optional converter = field.getConverter();
        if (converter.isPresent()) {
            AttributeConverter attributeConverter = this.getConverters().get((Class)converter.get());
            Object attributeConverted = attributeConverter.convertToEntityAttribute(value);
            field.write(instance, field.getValue(Value.of((Object)attributeConverted)));
        } else {
            field.write(instance, field.getValue(Value.of((Object)value)));
        }
    }

    private <T> void embeddedField(T instance, List<Property> elements, FieldMapping field) {
        field.write(instance, this.toEntity(field.getNativeField().getType(), elements));
    }

    protected FieldGraph to(FieldMapping field, Object entityInstance) {
        Object value = field.read(entityInstance);
        return FieldGraph.of(value, field);
    }

    private <T> T mapInheritanceEntity(Vertex vertex, List<Property> properties, Class<?> type) {
        Map group = this.getEntities().findByParentGroupByDiscriminatorValue(type);
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the vertex " + vertex.label());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::getDiscriminatorColumn).orElseThrow();
        String discriminator = properties.stream().filter(p -> p.key().equals(column)).map(Property::value).map(Object::toString).findFirst().orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Vertex, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata mapping = this.getEntities().get(inheritance.getEntity());
        return this.toEntity(mapping.getType(), properties);
    }
}

