/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.EntityTree;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.TreeEntry;

final class DefaultEntityTree
implements EntityTree {
    private final GraphConverter converter;
    private final Tree<Vertex> tree;

    DefaultEntityTree(GraphConverter converter, Tree<Vertex> tree) {
        this.converter = converter;
        this.tree = tree;
    }

    @Override
    public <T> Stream<T> getLeaf() {
        return this.tree.getLeafObjects().stream().map(this.converter::toEntity);
    }

    @Override
    public <T> Stream<T> getRoots() {
        return this.tree.keySet().stream().map(this.converter::toEntity);
    }

    @Override
    public <K, V> Stream<Map.Entry<K, V>> getRootsIds() {
        return this.tree.keySet().stream().map(v -> TreeEntry.of(v, this.converter));
    }

    @Override
    public <T> Optional<EntityTree> getTreeFromRoot(T id) {
        Objects.requireNonNull(id, "id is required");
        return this.tree.keySet().stream().filter(v -> id.equals(v.id())).findFirst().map(arg_0 -> this.tree.get(arg_0)).map(t -> new DefaultEntityTree(this.converter, (Tree<Vertex>)t));
    }

    @Override
    public Stream<EntityTree> getLeafTrees() {
        return this.tree.getLeafTrees().stream().map(t -> new DefaultEntityTree(this.converter, (Tree<Vertex>)t));
    }

    @Override
    public Stream<EntityTree> getTreesAtDepth(int depth) {
        return this.tree.getTreesAtDepth(depth).stream().map(t -> new DefaultEntityTree(this.converter, (Tree<Vertex>)t));
    }

    @Override
    public <T> Stream<T> getLeafsAtDepth(int depth) {
        return this.tree.getObjectsAtDepth(depth).stream().map(this.converter::toEntity);
    }

    @Override
    public boolean isLeaf() {
        return this.tree.isLeaf();
    }
}

