/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.mapping.EntityPostPersist;
import jakarta.nosql.mapping.EntityPrePersist;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.DefaultEntityPostPersist;
import org.eclipse.jnosql.mapping.DefaultEntityPrePersist;
import org.eclipse.jnosql.mapping.graph.EntityGraphPostPersist;
import org.eclipse.jnosql.mapping.graph.EntityGraphPrePersist;
import org.eclipse.jnosql.mapping.graph.GraphEntityPostPersist;
import org.eclipse.jnosql.mapping.graph.GraphEntityPrePersist;
import org.eclipse.jnosql.mapping.graph.GraphEventPersistManager;

@ApplicationScoped
class DefaultGraphEventPersistManager
implements GraphEventPersistManager {
    @Inject
    private Event<GraphEntityPrePersist> graphEntityPrePersistEvent;
    @Inject
    private Event<GraphEntityPostPersist> graphEntityPostPersistEvent;
    @Inject
    private Event<EntityPrePersist> entityPrePersistEvent;
    @Inject
    private Event<EntityPostPersist> entityPostPersistEvent;
    @Inject
    private Event<EntityGraphPrePersist> entityGraphPrePersist;
    @Inject
    private Event<EntityGraphPostPersist> entityGraphPostPersist;

    DefaultGraphEventPersistManager() {
    }

    @Override
    public void firePreGraph(Vertex entity) {
        this.graphEntityPrePersistEvent.fire((Object)GraphEntityPrePersist.of(entity));
    }

    @Override
    public void firePostGraph(Vertex entity) {
        this.graphEntityPostPersistEvent.fire((Object)GraphEntityPostPersist.of(entity));
    }

    @Override
    public <T> void firePreEntity(T entity) {
        this.entityPrePersistEvent.fire((Object)new DefaultEntityPrePersist(entity));
    }

    @Override
    public <T> void firePostEntity(T entity) {
        this.entityPostPersistEvent.fire((Object)new DefaultEntityPostPersist(entity));
    }

    @Override
    public <T> void firePreGraphEntity(T entity) {
        this.entityGraphPrePersist.fire((Object)EntityGraphPrePersist.of(entity));
    }

    @Override
    public <T> void firePostGraphEntity(T entity) {
        this.entityGraphPostPersist.fire((Object)EntityGraphPostPersist.of(entity));
    }
}

