/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.mapping.Converters;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.graph.DefaultGraphConverter;
import org.eclipse.jnosql.mapping.graph.DefaultGraphTemplate;
import org.eclipse.jnosql.mapping.graph.DefaultGraphTraversalSourceConverter;
import org.eclipse.jnosql.mapping.graph.DefaultGraphTraversalSourceTemplate;
import org.eclipse.jnosql.mapping.graph.DefaultGraphWorkflow;
import org.eclipse.jnosql.mapping.graph.GraphEventPersistManager;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.GraphTemplateProducer;
import org.eclipse.jnosql.mapping.graph.GraphTraversalSourceSupplier;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@ApplicationScoped
class DefaultGraphTemplateProducer
implements GraphTemplateProducer {
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;
    @Inject
    private GraphEventPersistManager persistManager;
    @Inject
    private GraphEventPersistManager eventManager;

    DefaultGraphTemplateProducer() {
    }

    public GraphTemplate get(Graph graph) {
        Objects.requireNonNull(graph, "graph is required");
        SingleInstance<Graph> instance = new SingleInstance<Graph>(graph);
        DefaultGraphConverter converter = new DefaultGraphConverter(this.entities, this.converters, instance, this.eventManager);
        DefaultGraphWorkflow workflow = new DefaultGraphWorkflow(this.persistManager, converter);
        return new DefaultGraphTemplate(instance, this.entities, converter, workflow, this.converters);
    }

    public GraphTemplate get(GraphTraversalSourceSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier is required");
        SingleInstance<GraphTraversalSourceSupplier> instance = new SingleInstance<GraphTraversalSourceSupplier>(supplier);
        DefaultGraphTraversalSourceConverter converter = new DefaultGraphTraversalSourceConverter(this.entities, this.converters, instance, this.eventManager);
        DefaultGraphWorkflow workflow = new DefaultGraphWorkflow(this.persistManager, converter);
        return new DefaultGraphTraversalSourceTemplate(instance, this.entities, converter, workflow, this.converters);
    }

    static class SingleInstance<T>
    implements Instance<T> {
        private final T instance;

        SingleInstance(T instance) {
            this.instance = instance;
        }

        public Instance<T> select(Annotation ... annotations) {
            throw new UnsupportedOperationException("this method is not support");
        }

        public <U extends T> Instance<U> select(Class<U> aClass, Annotation ... annotations) {
            throw new UnsupportedOperationException("this method is not support");
        }

        public <U extends T> Instance<U> select(TypeLiteral<U> typeLiteral, Annotation ... annotations) {
            throw new UnsupportedOperationException("this method is not support");
        }

        public boolean isUnsatisfied() {
            return false;
        }

        public boolean isAmbiguous() {
            return false;
        }

        public void destroy(T t) {
        }

        public Iterator<T> iterator() {
            return Collections.singletonList(this.instance).iterator();
        }

        public T get() {
            return this.instance;
        }
    }
}

