/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.EntityNotFoundException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.AbstractGraphConverter;
import org.eclipse.jnosql.mapping.graph.EdgeEntity;
import org.eclipse.jnosql.mapping.graph.FieldGraph;
import org.eclipse.jnosql.mapping.graph.GraphEventPersistManager;
import org.eclipse.jnosql.mapping.graph.GraphTraversalSourceOperation;
import org.eclipse.jnosql.mapping.graph.GraphTraversalSourceSupplier;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;

@GraphTraversalSourceOperation
@ApplicationScoped
class DefaultGraphTraversalSourceConverter
extends AbstractGraphConverter {
    private EntitiesMetadata entities;
    private Converters converters;
    private Instance<GraphTraversalSourceSupplier> suppliers;
    private GraphEventPersistManager eventManager;

    @Inject
    DefaultGraphTraversalSourceConverter(EntitiesMetadata entities, Converters converters, Instance<GraphTraversalSourceSupplier> suppliers, GraphEventPersistManager eventManager) {
        this.entities = entities;
        this.converters = converters;
        this.suppliers = suppliers;
        this.eventManager = eventManager;
    }

    DefaultGraphTraversalSourceConverter() {
    }

    @Override
    protected EntitiesMetadata getEntities() {
        return this.entities;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    protected GraphEventPersistManager getEventManager() {
        return this.eventManager;
    }

    @Override
    protected Graph getGraph() {
        throw new UnsupportedOperationException("GraphTraversalSource does not support graph instance");
    }

    @Override
    public <T> Vertex toVertex(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().get(entity.getClass());
        String label = mapping.getName();
        List fields = mapping.getFields().stream().map(f -> this.to((FieldMapping)f, entity)).filter(FieldGraph::isNotEmpty).collect(Collectors.toList());
        Optional<FieldGraph> id = fields.stream().filter(FieldGraph::isId).findFirst();
        Function<Property, Vertex> findVertexOrCreateWithId = p -> {
            GraphTraversal vertices = this.getTraversalSource().V(new Object[]{p.value()});
            return vertices.hasNext() ? (Vertex)vertices.next() : (Vertex)this.getTraversalSource().addV(label).property((Object)T.id, p.value(), new Object[0]).next();
        };
        Vertex vertex = id.map(i -> i.toElement(this.getConverters())).map(findVertexOrCreateWithId).orElseGet(() -> (Vertex)this.getTraversalSource().addV(label).next());
        fields.stream().filter(FieldGraph::isNotId).flatMap(f -> f.toElements(this, this.getConverters()).stream()).forEach(p -> vertex.property(p.key(), p.value()));
        mapping.getInheritance().ifPresent(i -> vertex.property(i.getDiscriminatorColumn(), (Object)i.getDiscriminatorValue()));
        return vertex;
    }

    @Override
    public Edge toEdge(EdgeEntity edge) {
        Objects.requireNonNull(edge, "vertex is required");
        Object id = edge.getId();
        GraphTraversal edges = this.getTraversalSource().E(new Object[]{id});
        if (edges.hasNext()) {
            return (Edge)edges.next();
        }
        throw new EntityNotFoundException("Edge does not found in the database with id: " + id);
    }

    private GraphTraversalSource getTraversalSource() {
        return (GraphTraversalSource)((GraphTraversalSourceSupplier)this.suppliers.get()).get();
    }
}

