/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.mapping.PreparedStatement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.eclipse.jnosql.mapping.graph.GremlinExecutor;

final class DefaultPreparedStatement
implements PreparedStatement {
    private final GremlinExecutor executor;
    private final String gremlin;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final GraphTraversalSource traversalSource;

    DefaultPreparedStatement(GremlinExecutor executor, String gremlin, GraphTraversalSource traversalSource) {
        this.executor = executor;
        this.gremlin = gremlin;
        this.traversalSource = traversalSource;
    }

    public PreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.params.put(name, value);
        return this;
    }

    public <T> Stream<T> getResult() {
        return this.executor.executeGremlin(this.traversalSource, this.gremlin, this.params);
    }

    public <T> Optional<T> getSingleResult() {
        Stream<T> entities = this.getResult();
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("There is more than one result found in the gremlin query: " + this.gremlin);
    }
}

