/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.mapping.Entity;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.AbstractVertexTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultEdgeTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultEntityTree;
import org.eclipse.jnosql.mapping.graph.DefaultValueMapTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultVertexRepeatTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultVertexTraversalOrder;
import org.eclipse.jnosql.mapping.graph.EdgeTraversal;
import org.eclipse.jnosql.mapping.graph.EntityTree;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphPage;
import org.eclipse.jnosql.mapping.graph.ValueMapTraversal;
import org.eclipse.jnosql.mapping.graph.VertexRepeatTraversal;
import org.eclipse.jnosql.mapping.graph.VertexTraversal;
import org.eclipse.jnosql.mapping.graph.VertexTraversalOrder;

class DefaultVertexTraversal
extends AbstractVertexTraversal
implements VertexTraversal {
    private static final Predicate<String> IS_EMPTY = String::isEmpty;
    private static final Predicate<String> NOT_EMPTY = IS_EMPTY.negate();

    DefaultVertexTraversal(Supplier<GraphTraversal<?, ?>> supplier, Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Vertex>> flow, GraphConverter converter) {
        super(supplier, flow, converter);
    }

    @Override
    public VertexTraversal has(String propertyKey, Object value) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, value)), this.converter);
    }

    @Override
    public VertexTraversal has(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey)), this.converter);
    }

    @Override
    public VertexTraversal has(String propertyKey, P<?> predicate) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, predicate)), this.converter);
    }

    @Override
    public VertexTraversal has(T accessor, Object value) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, value)), this.converter);
    }

    @Override
    public VertexTraversal has(T accessor, P<?> predicate) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, predicate)), this.converter);
    }

    @Override
    public VertexTraversal out(String ... labels) {
        Stream.of(labels).forEach(l -> Objects.requireNonNull(l, "label is required"));
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.out(labels)), this.converter);
    }

    @Override
    public <T> VertexTraversal filter(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is required");
        Predicate<Traverser> p = v -> predicate.test(this.converter.toEntity((Vertex)v.get()));
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.filter(p)), this.converter);
    }

    @Override
    public EdgeTraversal outE(String ... edgeLabels) {
        Stream.of(edgeLabels).forEach(l -> Objects.requireNonNull(l, "label is required"));
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.outE(edgeLabels)), this.converter);
    }

    @Override
    public VertexTraversal in(String ... labels) {
        Stream.of(labels).forEach(l -> Objects.requireNonNull(l, "label is required"));
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.in(labels)), this.converter);
    }

    @Override
    public EdgeTraversal inE(String ... edgeLabels) {
        Stream.of(edgeLabels).forEach(l -> Objects.requireNonNull(l, "edgeLabel is required"));
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.inE(edgeLabels)), this.converter);
    }

    @Override
    public VertexTraversal both(String ... labels) {
        Stream.of(labels).forEach(l -> Objects.requireNonNull(l, "labels is required"));
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.both(labels)), this.converter);
    }

    @Override
    public EdgeTraversal bothE(String ... edgeLabels) {
        Stream.of(edgeLabels).forEach(l -> Objects.requireNonNull(l, "edgeLabel is required"));
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.bothE(edgeLabels)), this.converter);
    }

    @Override
    public VertexTraversal dedup(String ... labels) {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.dedup(labels)), this.converter);
    }

    @Override
    public VertexRepeatTraversal repeat() {
        return new DefaultVertexRepeatTraversal(this.supplier, this.flow, this.converter);
    }

    @Override
    public VertexTraversal limit(long limit) {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.limit(limit)), this.converter);
    }

    @Override
    public VertexTraversal range(long start, long end) {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.range(start, end)), this.converter);
    }

    @Override
    public VertexTraversal hasLabel(String label) {
        Objects.requireNonNull(label, "label is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(label, new String[0])), this.converter);
    }

    @Override
    public <T> VertexTraversal hasLabel(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        Entity entity = type.getAnnotation(Entity.class);
        String label = Optional.ofNullable(entity).map(Entity::value).filter(NOT_EMPTY).orElse(type.getSimpleName());
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(label, new String[0])), this.converter);
    }

    @Override
    public <T> VertexTraversal hasLabel(P<String> predicate) {
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasLabel(predicate)), this.converter);
    }

    @Override
    public EntityTree tree() {
        Tree tree = (Tree)this.flow.andThen(GraphTraversal::tree).apply((GraphTraversal)this.supplier.get()).next();
        return new DefaultEntityTree(this.converter, (Tree<Vertex>)tree);
    }

    @Override
    public VertexTraversal hasNot(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(g -> g.hasNot(propertyKey)), this.converter);
    }

    @Override
    public <T> Optional<T> next() {
        Optional vertex = ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).tryNext();
        return vertex.map(this.converter::toEntity);
    }

    @Override
    public <T> Stream<T> getResult() {
        return ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).toStream().map(this.converter::toEntity);
    }

    @Override
    public <T> Optional<T> getSingleResult() {
        Stream<T> stream = this.getResult();
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("The Vertex traversal query returns more than one result");
    }

    @Override
    public <T> Page<T> page(Pagination pagination) {
        Objects.requireNonNull(pagination, "pagination is required");
        GraphTraversal graphTraversal = (GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get());
        graphTraversal.skip(pagination.getSkip());
        return GraphPage.of(pagination, this.converter, graphTraversal);
    }

    @Override
    public <T> Stream<T> next(int limit) {
        return ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).next(limit).stream().map(this.converter::toEntity);
    }

    @Override
    public ValueMapTraversal valueMap(String ... propertyKeys) {
        return new DefaultValueMapTraversal(this.supplier, this.flow.andThen(g -> g.valueMap(false, propertyKeys)));
    }

    @Override
    public long count() {
        return ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).count().tryNext().orElse(0L);
    }

    @Override
    public VertexTraversalOrder orderBy(String property) {
        Objects.requireNonNull(property, "property is required");
        return new DefaultVertexTraversalOrder(this.supplier, this.flow, this.converter, property);
    }
}

