/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.GraphConverter;

public final class GraphPage<T>
implements Page<T> {
    private final Pagination pagination;
    private final GraphConverter converter;
    private final GraphTraversal<?, ?> graphTraversal;
    private final Stream<T> entities;
    private List<T> entitiesCache;

    private GraphPage(Pagination pagination, GraphConverter converter, GraphTraversal<?, ?> graphTraversal, Stream<T> entities) {
        this.pagination = pagination;
        this.converter = converter;
        this.graphTraversal = graphTraversal;
        this.entities = entities;
    }

    public Pagination getPagination() {
        return this.pagination.unmodifiable();
    }

    public Page<T> next() {
        return new GraphPage<T>(this.pagination.next(), this.converter, this.graphTraversal, GraphPage.toEntity(this.pagination, this.converter, this.graphTraversal));
    }

    public Stream<T> getContent() {
        return this.getEntities();
    }

    public <C extends Collection<T>> C getContent(Supplier<C> collectionFactory) {
        Objects.requireNonNull(collectionFactory, "collectionFactory is required");
        return (C)((Collection)this.getEntities().collect(Collectors.toCollection(collectionFactory)));
    }

    public Stream<T> get() {
        return this.getEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<T> getEntities() {
        if (Objects.isNull(this.entitiesCache)) {
            GraphPage graphPage = this;
            synchronized (graphPage) {
                this.entitiesCache = this.entities.collect(Collectors.toList());
            }
        }
        return this.entitiesCache.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphPage graphPage = (GraphPage)o;
        return Objects.equals(this.pagination, graphPage.pagination) && Objects.equals(this.graphTraversal, graphPage.graphTraversal) && Objects.equals(this.entities, graphPage.entities);
    }

    public int hashCode() {
        return Objects.hash(this.pagination, this.graphTraversal, this.entities);
    }

    public String toString() {
        return "GraphPage{pagination=" + this.pagination + ", graphTraversal=" + this.graphTraversal + ", entities=" + this.entities + "}";
    }

    static <T> Page<T> of(Pagination pagination, GraphConverter converter, GraphTraversal<?, ?> graphTraversal) {
        Objects.requireNonNull(pagination, "pagination is required");
        Objects.requireNonNull(converter, "converter is required");
        Objects.requireNonNull(graphTraversal, "graphTraversal is required");
        graphTraversal.skip(pagination.getSkip());
        return new GraphPage<T>(pagination, converter, graphTraversal, GraphPage.toEntity(pagination, converter, graphTraversal));
    }

    private static <T> Stream<T> toEntity(Pagination pagination, GraphConverter converter, GraphTraversal<?, ?> graphTraversal) {
        return graphTraversal.next((int)pagination.getLimit()).stream().map(v -> converter.toEntity((Vertex)v));
    }
}

