/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GremlinQueryException;

final class GremlinExecutor {
    private final GraphConverter converter;
    private static final ScriptEngine ENGINE = new GremlinGroovyScriptEngine();

    GremlinExecutor(GraphConverter converter) {
        this.converter = converter;
    }

    <T> Stream<T> executeGremlin(GraphTraversalSource traversalSource, String gremlin) {
        return this.executeGremlin(traversalSource, gremlin, Collections.emptyMap());
    }

    <T> Stream<T> executeGremlin(GraphTraversalSource traversalSource, String gremlin, Map<String, Object> params) {
        try {
            Bindings bindings = ENGINE.createBindings();
            bindings.put("g", (Object)traversalSource);
            bindings.putAll((Map<? extends String, ? extends Object>)params);
            Object eval = ENGINE.eval(gremlin, bindings);
            if (eval instanceof GraphTraversal) {
                return this.convertToStream(((GraphTraversal)eval).toStream());
            }
            if (eval instanceof Iterable) {
                return this.convertToStream(StreamSupport.stream(((Iterable)eval).spliterator(), false));
            }
            if (eval instanceof Stream) {
                return this.convertToStream((Stream)eval);
            }
            return Stream.of(eval);
        }
        catch (ScriptException e) {
            throw new GremlinQueryException("There is an error when executed the gremlin query: " + gremlin, e);
        }
    }

    private <T> Stream<T> convertToStream(Stream<?> stream) {
        return stream.map(this::getElement).map(e -> e);
    }

    private Object getElement(Object entity) {
        if (entity instanceof Vertex) {
            return this.converter.toEntity((Vertex)entity);
        }
        if (entity instanceof Edge) {
            return this.converter.toEdgeEntity((Edge)entity);
        }
        return entity;
    }
}

