/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.Map;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.EdgeEntity;
import org.eclipse.jnosql.mapping.graph.GraphConverter;

final class TreeEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;

    private TreeEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V v) {
        throw new UnsupportedOperationException("This entry is read-only");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeEntry that = (TreeEntry)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "EntityTreeEntry{key=" + this.key + ", value=" + this.value + "}";
    }

    static <K, V> TreeEntry<K, V> of(Vertex vertex, GraphConverter converter) {
        Object key = vertex.id();
        Object value = converter.toEntity(vertex);
        return new TreeEntry(key, value);
    }

    static <K> TreeEntry<K, EdgeEntity> of(Edge edge, GraphConverter converter) {
        Object key = edge.id();
        EdgeEntity value = converter.toEdgeEntity(edge);
        return new TreeEntry<Object, EdgeEntity>(key, value);
    }
}

