/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.configuration;

import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.config.MicroProfileSettings;
import org.eclipse.jnosql.mapping.graph.GraphConfiguration;
import org.eclipse.jnosql.mapping.reflection.Reflections;

@ApplicationScoped
class GraphSupplier
implements Supplier<Graph> {
    GraphSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public Graph get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        GraphConfiguration configuration = settings.get((Supplier)MappingConfigurations.GRAPH_PROVIDER, Class.class).filter(GraphConfiguration.class::isAssignableFrom).map(c -> {
            Reflections reflections = (Reflections)CDI.current().select(Reflections.class, new Annotation[0]).get();
            return (GraphConfiguration)reflections.newInstance(c);
        }).orElseGet(GraphConfiguration::getConfiguration);
        Graph graph = (Graph)configuration.apply(settings);
        return graph;
    }

    public void close(@Disposes Graph graph) throws Exception {
        graph.close();
    }
}

