/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.DynamicQueryException;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.Repository;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.query.DeleteQueryConverter;
import org.eclipse.jnosql.mapping.graph.query.GraphQueryMethod;
import org.eclipse.jnosql.mapping.graph.query.SelectQueryConverter;
import org.eclipse.jnosql.mapping.query.RepositoryType;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.repository.DynamicQueryMethodReturn;
import org.eclipse.jnosql.mapping.repository.DynamicReturn;

abstract class AbstractGraphRepositoryProxy<T, K>
implements InvocationHandler {
    AbstractGraphRepositoryProxy() {
    }

    protected abstract EntityMetadata getEntityMetadata();

    protected abstract Repository getRepository();

    protected abstract Graph getGraph();

    protected abstract GraphConverter getConverter();

    protected abstract GraphTemplate getTemplate();

    protected abstract Converters getConverters();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        Class typeClass = this.getEntityMetadata().getType();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                return this.findBy(method, args, typeClass);
            }
            case FIND_ALL: {
                return this.findAll(method, typeClass, args);
            }
            case DELETE_BY: {
                return this.executeDeleteMethod(method, args);
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case UNKNOWN: 
            case JNOSQL_QUERY: {
                DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(args).withMethod(method).withTypeClass(typeClass).withPrepareConverter(q -> this.getTemplate().prepare((String)q)).withQueryConverter(q -> this.getTemplate().query((String)q)).build();
                return methodReturn.execute();
            }
        }
        return Void.class;
    }

    private Object findAll(Method method, Class<?> typeClass, Object[] args) {
        Supplier<Stream<?>> querySupplier = () -> {
            GraphTraversal traversal = this.getGraph().traversal().V(new Object[0]).hasLabel(this.getEntityMetadata().getName(), new String[0]);
            SelectQueryConverter.setSort(args, (GraphTraversal<Vertex, Vertex>)traversal);
            SelectQueryConverter.setPagination(args, (GraphTraversal<Vertex, Vertex>)traversal);
            return traversal.toStream().map(this.getConverter()::toEntity);
        };
        return this.converter(method, typeClass, querySupplier, args);
    }

    private Object findBy(Method method, Object[] args, Class<?> typeClass) {
        Supplier<Stream<?>> querySupplier = () -> {
            GraphQueryMethod queryMethod = new GraphQueryMethod(this.getEntityMetadata(), (GraphTraversal<Vertex, Vertex>)this.getGraph().traversal().V(new Object[0]), this.getConverters(), method, args);
            return SelectQueryConverter.INSTANCE.apply(queryMethod, args).map(this.getConverter()::toEntity);
        };
        return this.converter(method, typeClass, querySupplier, args);
    }

    private Object converter(Method method, Class<?> typeClass, Supplier<Stream<?>> querySupplier, Object[] args) {
        Supplier singleSupplier = (Supplier)DynamicReturn.toSingleResult((Method)method).apply(querySupplier);
        Function<Pagination, Page> pageFunction = p -> {
            throw new DynamicQueryException("Graph database repository does not support Page as return Type");
        };
        DynamicReturn dynamicReturn = DynamicReturn.builder().withClassSource(typeClass).withMethodSource(method).withResult(querySupplier).withSingleResult(singleSupplier).withPagination(DynamicReturn.findPagination((Object[])args)).withStreamPagination(p -> querySupplier.get()).withSingleResultPagination(arg_0 -> AbstractGraphRepositoryProxy.lambda$converter$6((Supplier)singleSupplier, arg_0)).withPage(pageFunction).build();
        return dynamicReturn.execute();
    }

    private Object executeDeleteMethod(Method method, Object[] args) {
        GraphQueryMethod queryMethod = new GraphQueryMethod(this.getEntityMetadata(), (GraphTraversal<Vertex, Vertex>)this.getGraph().traversal().V(new Object[0]), this.getConverters(), method, args);
        List<Vertex> vertices = DeleteQueryConverter.INSTANCE.apply(queryMethod);
        vertices.forEach(Element::remove);
        return Void.class;
    }

    private static /* synthetic */ Object lambda$converter$6(Supplier singleSupplier, Object p) {
        return singleSupplier.get();
    }
}

