/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.query;

import jakarta.nosql.query.Condition;
import jakarta.nosql.query.ConditionQueryValue;
import jakarta.nosql.query.Operator;
import jakarta.nosql.query.Where;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.query.GraphQueryMethod;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

abstract class AbstractQueryConvert {
    AbstractQueryConvert() {
    }

    protected GraphTraversal<Vertex, Vertex> getPredicate(GraphQueryMethod graphQuery, Condition condition, EntityMetadata mapping) {
        Operator operator = condition.getOperator();
        String name = condition.getName();
        String nativeName = mapping.getColumnField(name);
        switch (operator) {
            case EQUALS: {
                return __.has((String)nativeName, (P)P.eq((Object)graphQuery.getValue(name)));
            }
            case GREATER_THAN: {
                return __.has((String)nativeName, (P)P.gt((Object)graphQuery.getValue(name)));
            }
            case GREATER_EQUALS_THAN: {
                return __.has((String)nativeName, (P)P.gte((Object)graphQuery.getValue(name)));
            }
            case LESSER_THAN: {
                return __.has((String)nativeName, (P)P.lt((Object)graphQuery.getValue(name)));
            }
            case LESSER_EQUALS_THAN: {
                return __.has((String)nativeName, (P)P.lte((Object)graphQuery.getValue(name)));
            }
            case BETWEEN: {
                return __.has((String)nativeName, (P)P.between((Object)graphQuery.getValue(name), (Object)graphQuery.getValue(name)));
            }
            case IN: {
                return __.has((String)nativeName, (P)P.within(graphQuery.getInValue(name)));
            }
            case NOT: {
                Condition notCondition = (Condition)((List)((ConditionQueryValue)condition.getValue()).get()).get(0);
                return __.not(this.getPredicate(graphQuery, notCondition, mapping));
            }
            case AND: {
                return ((List)((ConditionQueryValue)condition.getValue()).get()).stream().map(c -> this.getPredicate(graphQuery, (Condition)c, mapping)).reduce((rec$, xva$0) -> ((GraphTraversal)rec$).and(new Traversal[]{xva$0})).orElseThrow(() -> new UnsupportedOperationException("There is an inconsistency at the AND operator"));
            }
            case OR: {
                return ((List)((ConditionQueryValue)condition.getValue()).get()).stream().map(c -> this.getPredicate(graphQuery, (Condition)c, mapping)).reduce((rec$, xva$0) -> ((GraphTraversal)rec$).or(new Traversal[]{xva$0})).orElseThrow(() -> new UnsupportedOperationException("There is an inconsistency at the OR operator"));
            }
        }
        throw new UnsupportedOperationException("There is not support to the type " + operator + " in graph");
    }

    protected GraphTraversal<Vertex, Vertex> getGraphTraversal(GraphQueryMethod graphQuery, Supplier<Optional<Where>> whereSupplier, EntityMetadata mapping) {
        GraphTraversal<Vertex, Vertex> traversal = graphQuery.getTraversal();
        Optional<Where> whereOptional = whereSupplier.get();
        if (whereOptional.isPresent()) {
            Where where = whereOptional.get();
            Condition condition = where.getCondition();
            traversal.filter(this.getPredicate(graphQuery, condition, mapping));
        }
        return traversal;
    }
}

