/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Repository;
import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphRepositoryProducer;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.GraphTemplateProducer;
import org.eclipse.jnosql.mapping.graph.query.GraphRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;

@ApplicationScoped
class DefaultGraphRepositoryProducer
implements GraphRepositoryProducer {
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private GraphConverter converter;
    @Inject
    private GraphTemplateProducer producer;
    @Inject
    private Converters converters;

    DefaultGraphRepositoryProducer() {
    }

    @Override
    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, Graph manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        Object template = this.producer.get(manager);
        GraphRepositoryProxy handler = new GraphRepositoryProxy((GraphTemplate)template, this.entities, repositoryClass, manager, this.converter, this.converters);
        return (R)((Repository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

