/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Repository;
import java.lang.reflect.ParameterizedType;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.query.AbstractGraphRepository;
import org.eclipse.jnosql.mapping.graph.query.AbstractGraphRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

class GraphRepositoryProxy<T, K>
extends AbstractGraphRepositoryProxy<T, K> {
    private final GraphRepository repository;
    private final EntityMetadata entityMetadata;
    private final Graph graph;
    private final GraphConverter converter;
    private final GraphTemplate template;
    private final Converters converters;

    GraphRepositoryProxy(GraphTemplate template, EntitiesMetadata entities, Class<?> repositoryType, Graph graph, GraphConverter converter, Converters converters) {
        Class typeClass = (Class)((ParameterizedType)repositoryType.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.graph = graph;
        this.converter = converter;
        this.entityMetadata = entities.get(typeClass);
        this.repository = new GraphRepository(template, this.entityMetadata);
        this.template = template;
        this.converters = converters;
    }

    @Override
    protected EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected Graph getGraph() {
        return this.graph;
    }

    @Override
    protected GraphConverter getConverter() {
        return this.converter;
    }

    @Override
    protected GraphTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    static class GraphRepository
    extends AbstractGraphRepository
    implements Repository {
        private final GraphTemplate template;
        private final EntityMetadata entityMetadata;

        GraphRepository(GraphTemplate template, EntityMetadata entityMetadata) {
            this.template = template;
            this.entityMetadata = entityMetadata;
        }

        @Override
        protected GraphTemplate getTemplate() {
            return this.template;
        }

        @Override
        protected EntityMetadata getEntityMetadata() {
            return this.entityMetadata;
        }
    }
}

