/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.query;

import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.query.SelectQuery;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.communication.query.method.SelectMethodProvider;
import org.eclipse.jnosql.mapping.graph.query.AbstractQueryConvert;
import org.eclipse.jnosql.mapping.graph.query.GraphQueryMethod;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.repository.DynamicReturn;

final class SelectQueryConverter
extends AbstractQueryConvert
implements BiFunction<GraphQueryMethod, Object[], Stream<Vertex>> {
    static final SelectQueryConverter INSTANCE = new SelectQueryConverter();

    private SelectQueryConverter() {
    }

    @Override
    public Stream<Vertex> apply(GraphQueryMethod graphQuery, Object[] params) {
        SelectMethodProvider selectMethodFactory = SelectMethodProvider.get();
        SelectQuery query = (SelectQuery)selectMethodFactory.apply((Object)graphQuery.getMethod(), (Object)graphQuery.getEntityName());
        EntityMetadata mapping = graphQuery.getMapping();
        GraphTraversal<Vertex, Vertex> traversal = this.getGraphTraversal(graphQuery, () -> ((SelectQuery)query).getWhere(), mapping);
        query.getOrderBy().forEach(this.getSort(traversal, mapping));
        SelectQueryConverter.setSort(params, traversal);
        SelectQueryConverter.setPagination(params, traversal, query);
        traversal.hasLabel(mapping.getName(), new String[0]);
        return traversal.toStream();
    }

    private Consumer<Sort> getSort(GraphTraversal<Vertex, Vertex> traversal, EntityMetadata mapping) {
        return o -> {
            if (SortType.ASC.equals((Object)o.getType())) {
                traversal.order().by(mapping.getColumnField(o.getName()), (Comparator)Order.asc);
            } else {
                traversal.order().by(mapping.getColumnField(o.getName()), (Comparator)Order.desc);
            }
        };
    }

    static void setPagination(Object[] args, GraphTraversal<Vertex, Vertex> traversal) {
        SelectQueryConverter.setPagination(args, traversal, null);
    }

    private static void setPagination(Object[] args, GraphTraversal<Vertex, Vertex> traversal, SelectQuery query) {
        Pagination pagination = DynamicReturn.findPagination((Object[])args);
        if (pagination != null) {
            traversal.skip(pagination.getSkip()).limit(pagination.getLimit());
            return;
        }
        if (query != null) {
            if (query.getSkip() > 0L) {
                traversal.skip(query.getSkip());
            }
            if (query.getLimit() > 0L) {
                traversal.next((int)query.getLimit());
            }
        }
    }

    static void setSort(Object[] args, GraphTraversal<Vertex, Vertex> traversal) {
        List sorts = DynamicReturn.findSorts((Object[])args);
        if (!sorts.isEmpty()) {
            for (Sort sort : sorts) {
                traversal.order().by(sort.getName(), (Comparator)(sort.getType() == SortType.ASC ? Order.asc : Order.desc));
            }
        }
    }
}

